/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.menu;

import dev.ftb.mods.ftbunearthed.block.UneartherCoreBlockEntity;
import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.menu.OutputOnlySlot;
import dev.ftb.mods.ftbunearthed.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class UneartherMenu
extends AbstractContainerMenu {
    public static final int PLAYER_INV_Y = 84;
    private final UneartherCoreBlockEntity unearther;
    private final ContainerData data;

    public UneartherMenu(int containerId, Inventory invPlayer, BlockPos pos, ContainerData data) {
        super(ModMenuTypes.UNEARTHER_MENU.get(), containerId);
        this.data = data;
        this.unearther = (UneartherCoreBlockEntity)((Object)invPlayer.player.level().getBlockEntity(pos, (BlockEntityType)ModBlockEntityTypes.UNEARTHER_CORE.get()).orElseThrow(() -> new IllegalStateException("unearther block entity missing at " + String.valueOf(pos))));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = 9 + y * 9 + x;
                this.addSlot(new Slot((Container)invPlayer, slot, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)invPlayer, x, 8 + x * 18, 142));
        }
        this.addSlot((Slot)new SlotItemHandler(this.unearther.getInputHandler(), 0, 62, 18));
        this.addSlot((Slot)new SlotItemHandler(this.unearther.getFoodHandler(), 0, 26, 18));
        this.addSlot((Slot)new SlotItemHandler(this.unearther.getWorkerHandler(), 0, 26, 53));
        this.addSlot((Slot)new SlotItemHandler(this.unearther.getToolHandler(), 0, 62, 53));
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new OutputOnlySlot((IItemHandler)this.unearther.getOutputHandler(), i, 116 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
        this.addDataSlots(data);
    }

    public static UneartherMenu fromNetwork(int windowId, Inventory inventory, RegistryFriendlyByteBuf buf) {
        return new UneartherMenu(windowId, inventory, buf.readBlockPos(), (ContainerData)new SimpleContainerData(4));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            resultStack = stackInSlot.copy();
            if (index < 36 ? !this.moveItemStackTo(stackInSlot, 36, 40, false) : !this.moveItemStackTo(stackInSlot, 27, 36, false) && !this.moveItemStackTo(stackInSlot, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return resultStack;
    }

    public boolean stillValid(Player player) {
        return !this.unearther.isRemoved() && player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.unearther.getBlockPos())) < 64.0;
    }

    public UneartherCoreBlockEntity getUnearther() {
        return this.unearther;
    }

    public float getProgress() {
        int processingTime = this.data.get(0);
        int progress = this.data.get(1);
        return processingTime == 0 || progress <= 0 ? 0.0f : 1.0f - (float)progress / (float)processingTime;
    }

    public float getFoodBuffer() {
        return Mth.clamp((float)((float)this.data.get(2) / (float)((Integer)ServerConfig.MAX_FOOD_BUFFER.get()).intValue()), (float)0.0f, (float)1.0f);
    }

    public int getSpeedBoost() {
        return this.data.get(3);
    }
}

