/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.util;

import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.crafting.RecipeCaches;
import dev.ftb.mods.ftbunearthed.crafting.recipe.UneartherRecipe;
import dev.ftb.mods.ftbunearthed.integration.ultimine.UltimineIntegration;
import dev.ftb.mods.ftbunearthed.net.SendMultibreakProgressMessage;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import dev.ftb.mods.ftbunearthed.util.MiscUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public class ManualBrushing {
    private static final Map<ResourceLocation, Object2FloatMap<BlockPos>> brushProgress = new Object2ObjectOpenHashMap();

    public static boolean tryManualBrushing(LivingEntity livingEntity, ItemStack stack, BlockHitResult blockHitResult) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        BlockPos pos = blockHitResult.getBlockPos();
        ItemStack input = player.level().getBlockState(pos).getBlock().asItem().getDefaultInstance();
        return ManualBrushing.findRecipe(player, input).map(recipe -> ManualBrushing.doBrushing(player, stack, pos, recipe)).orElse(false);
    }

    private static Optional<UneartherRecipe> findRecipe(ServerPlayer player, ItemStack input) {
        int lvl = MiscUtil.getPlayerUneatherLevel((Player)player);
        ItemStack toolStack = player.getMainHandItem();
        return RecipeCaches.MANUAL_BRUSHING.getCachedRecipe(() -> RecipeCaches.sortedUneartherRecipes(player.level()).stream().filter(holder -> ((UneartherRecipe)holder.value()).testManual(input, lvl, toolStack)).findFirst(), () -> Objects.hash(input, ItemStack.hashItemAndComponents((ItemStack)toolStack), lvl)).map(RecipeHolder::value);
    }

    private static boolean doBrushing(ServerPlayer player, ItemStack stack, BlockPos pos, UneartherRecipe recipe) {
        Level level = player.level();
        ArrayList<BlockPos> allPositions = new ArrayList<BlockPos>(UltimineIntegration.getSelectedPositions(player, pos));
        if (allPositions.isEmpty()) {
            return true;
        }
        int minToolDurability = allPositions.size() > 1 ? UltimineIntegration.minToolDurability() : 0;
        EquipmentSlot slot = ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        ItemStack tool = player.getItemBySlot(slot);
        Object2FloatMap progressMap = brushProgress.computeIfAbsent(level.dimension().location(), k -> new Object2FloatOpenHashMap());
        float duration = (float)recipe.getProcessingTime() / ((Double)ServerConfig.MANUAL_BRUSHING_SPEEDUP.get()).floatValue();
        if (tool.has(ModDataComponents.SUPER_BRUSH)) {
            float boost = (float)(100 + (Integer)ServerConfig.SUPER_BRUSH_SPEED_BOOST.get()) / 100.0f;
            duration /= boost;
        }
        float step = 1.0f / (duration / 100.0f);
        float progress = progressMap.getOrDefault((Object)pos, 0.0f) + step;
        progressMap.put((Object)pos, progress);
        if (progress >= 10.0f) {
            ManualBrushing.sendBreakProgress(player, pos, allPositions, -1);
            BlockState origState = level.getBlockState(pos);
            for (BlockPos p1 : allPositions) {
                if (level.getBlockState(p1) != origState) continue;
                if (tool.isEmpty() || tool.isDamageableItem() && tool.getDamageValue() >= tool.getMaxDamage() - minToolDurability) break;
                level.destroyBlock(p1, false, (Entity)player);
                recipe.generateOutputs(player.getRandom()).forEach(output -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)output));
                if (!(recipe.getDamageChance() >= 1.0f) && !(player.getRandom().nextFloat() < recipe.getDamageChance())) continue;
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
            }
            progressMap.removeFloat((Object)pos);
        } else {
            ManualBrushing.sendBreakProgress(player, pos, allPositions, (int)progress);
        }
        return true;
    }

    private static void sendBreakProgress(ServerPlayer player, BlockPos pos0, Collection<BlockPos> allPositions, int progress) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), (CustomPacketPayload)SendMultibreakProgressMessage.create(pos0, allPositions, progress), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

