/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.ftb.mods.ftboceanmobs.client.model.RiftlingObserverModel;
import dev.ftb.mods.ftboceanmobs.entity.RiftlingObserver;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RiftlingObserverRenderer
extends GeoEntityRenderer<RiftlingObserver> {
    public RiftlingObserverRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new RiftlingObserverModel());
        this.addRenderLayer(new EyeBeamLayer());
    }

    private static Vec3 getPosition(LivingEntity livingEntity, double yOffset, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + yOffset;
        double d2 = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(d0, d1, d2);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private class EyeBeamLayer
    extends GeoRenderLayer<RiftlingObserver> {
        private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png");
        private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_LOCATION);

        public EyeBeamLayer() {
            super((GeoRenderer)RiftlingObserverRenderer.this);
        }

        public void render(PoseStack poseStack, RiftlingObserver entity, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            super.render(poseStack, (GeoAnimatable)((RiftlingObserver)RiftlingObserverRenderer.this.animatable), bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            LivingEntity livingentity = entity.getSyncedGazeTarget();
            if (livingentity != null) {
                float gazeScale = entity.getAttackAnimationScale(partialTick);
                float gazeWarmupTime = entity.getClientSideAttackTime() + partialTick;
                float f2 = gazeWarmupTime * 0.5f % 1.0f;
                float eyeY = entity.getEyeHeight();
                poseStack.pushPose();
                poseStack.translate(0.0f, eyeY, 0.0f);
                Vec3 vec3 = RiftlingObserverRenderer.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5, partialTick);
                Vec3 vec31 = RiftlingObserverRenderer.getPosition((LivingEntity)entity, eyeY, partialTick);
                Vec3 vec32 = vec3.subtract(vec31);
                float f4 = (float)(vec32.length() + 1.0);
                vec32 = vec32.normalize();
                float f5 = (float)Math.acos(vec32.y);
                float f6 = (float)Math.atan2(vec32.z, vec32.x);
                poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
                poseStack.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
                float f7 = gazeWarmupTime * 0.05f * -1.5f;
                float gazeScaleSq = gazeScale * gazeScale;
                int red = 58 + (int)(gazeScaleSq * 130.0f);
                int green = 50 - (int)(gazeScaleSq * 7.0f);
                int blue = 188 + (int)(gazeScaleSq * 50.0f);
                float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
                float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
                float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
                float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
                float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
                float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
                float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
                float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
                float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
                float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
                float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
                float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
                float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
                float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
                float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
                float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
                float f29 = -1.0f + f2;
                float f30 = f4 * 2.5f + f29;
                VertexConsumer vertexconsumer = bufferSource.getBuffer(BEAM_RENDER_TYPE);
                PoseStack.Pose posestack$pose = poseStack.last();
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f19, f4, f20, red, green, blue, 0.4999f, f30);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f19, 0.0f, f20, red, green, blue, 0.4999f, f29);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f21, 0.0f, f22, red, green, blue, 0.0f, f29);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f21, f4, f22, red, green, blue, 0.0f, f30);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f23, f4, f24, red, green, blue, 0.4999f, f30);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f23, 0.0f, f24, red, green, blue, 0.4999f, f29);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f25, 0.0f, f26, red, green, blue, 0.0f, f29);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f25, f4, f26, red, green, blue, 0.0f, f30);
                float f31 = 0.0f;
                if (entity.tickCount % 2 == 0) {
                    f31 = 0.5f;
                }
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f11, f4, f12, red, green, blue, 0.5f, f31 + 0.5f);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f13, f4, f14, red, green, blue, 1.0f, f31 + 0.5f);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f17, f4, f18, red, green, blue, 1.0f, f31);
                RiftlingObserverRenderer.vertex(vertexconsumer, posestack$pose, f15, f4, f16, red, green, blue, 0.5f, f31);
                poseStack.popPose();
            }
        }
    }
}

