/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.datagen;

import dev.ftb.mods.ftboceanmobs.FTBOceanMobs;
import dev.ftb.mods.ftboceanmobs.FTBOceanMobsTags;
import dev.ftb.mods.ftboceanmobs.registry.ModEntityTypes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EnchantmentTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class ModTagsProvider {

    public static class Enchantment
    extends EnchantmentTagsProvider {
        public Enchantment(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "ftboceanmobs", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(EnchantmentTags.NON_TREASURE).add(FTBOceanMobs.RIFT_DISRUPTOR_ENCHANTMENT);
            this.tag(EnchantmentTags.DAMAGE_EXCLUSIVE).add(FTBOceanMobs.RIFT_DISRUPTOR_ENCHANTMENT);
        }
    }

    public static class Block
    extends BlockTagsProvider {
        public Block(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "ftboceanmobs", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).add((Object)Blocks.SANDSTONE);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).add((Object)Blocks.CRIMSON_PLANKS);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).add((Object)Blocks.BLACKSTONE);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).add((Object)Blocks.COBBLED_DEEPSLATE);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).add((Object)Blocks.DEEPSLATE_BRICKS);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE).addTag(Tags.Blocks.GLASS_BLOCKS);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED).add((Object)Blocks.CRIMSON_SLAB);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED).add((Object)Blocks.CRIMSON_STAIRS);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED).add((Object)Blocks.BLACKSTONE_SLAB);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED).add((Object)Blocks.CRACKED_DEEPSLATE_BRICKS);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED).add((Object)Blocks.CRACKED_DEEPSLATE_TILES);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHED).add((Object)Blocks.RED_SAND);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHED).add((Object)Blocks.SAND);
            this.tag(FTBOceanMobsTags.Blocks.SEISMIC_SMASHED).add((Object)Blocks.GRAVEL);
            this.tag(FTBOceanMobsTags.Blocks.DROWNING_SHADOWS_CURE).add((Object)Blocks.SPONGE);
            this.tag(FTBOceanMobsTags.Blocks.DROWNING_SHADOWS_CURE).add((Object)Blocks.WET_SPONGE);
        }
    }

    public static class EntityType
    extends EntityTypeTagsProvider {
        public EntityType(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "ftboceanmobs", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (DeferredHolder type : ModEntityTypes.ENTITY_TYPES.getEntries()) {
                if (type == ModEntityTypes.TUMBLING_BLOCK) continue;
                this.tag(FTBOceanMobsTags.Entity.RIFT_MOBS).add((Object)((net.minecraft.world.entity.EntityType)type.get()));
            }
            this.tag(EntityTypeTags.CAN_BREATHE_UNDER_WATER).addTag(FTBOceanMobsTags.Entity.RIFT_MOBS);
        }
    }
}

