/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.ChargeGoal;
import dev.ftb.mods.ftboceanmobs.mobai.DelayedMeleeAttackGoal;
import dev.ftb.mods.ftboceanmobs.mobai.IChargingMob;
import dev.ftb.mods.ftboceanmobs.mobai.IThrowingMob;
import dev.ftb.mods.ftboceanmobs.mobai.ThrowBlockGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiftMinotaur
extends BaseRiftMob
implements IChargingMob,
IThrowingMob {
    private static final int THROW_TICKS = 40;
    private static final int PICKUP_TICKS = 10;
    private static final int LAUNCH_TICKS = 26;
    private static final float THROW_CHANCE = 0.03f;
    protected static final EntityDataAccessor<Byte> DATA_STATE = SynchedEntityData.defineId(RiftMinotaur.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final byte STATE_NONE = 0;
    private static final byte STATE_THROW = 1;
    private static final byte STATE_WARMUP_CHARGE = 2;
    private static final byte STATE_DO_CHARGE = 3;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RiftMinotaur(EntityType<? extends RiftMinotaur> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.28f).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ARMOR, 12.0).add(Attributes.ARMOR_TOUGHNESS, 8.0).add(Attributes.FOLLOW_RANGE, 36.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.ATTACK_KNOCKBACK, 2.5).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 12.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ChargeGoal((PathfinderMob)this, 1.5f));
        this.goalSelector.addGoal(1, (Goal)new ThrowBlockGoal((Mob)this, 40, 10, 26, 0.03f));
        this.goalSelector.addGoal(2, (Goal)new DelayedMeleeAttackGoal((PathfinderMob)this, 1.0, false, 16));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 10, state -> state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 5, this::attackState));
    }

    protected float getKnockback(Entity attacker, DamageSource damageSource) {
        float knockback = super.getKnockback(attacker, damageSource);
        return this.isSprinting() ? knockback * 2.0f : knockback;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        SpawnGroupData data = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setLeftHanded(true);
        return data;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.DIAMOND_AXE));
    }

    public int getCurrentSwingDuration() {
        return 24;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.4);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.MINOTAUR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.7f;
    }

    private PlayState attackState(AnimationState<RiftMinotaur> state) {
        if (this.isThrowing()) {
            return state.setAndContinue(DefaultAnimations.ATTACK_THROW);
        }
        if (this.isAboutToCharge()) {
            return state.setAndContinue(DefaultAnimations.ATTACK_POWERUP);
        }
        if (this.isCharging()) {
            return state.setAndContinue(DefaultAnimations.ATTACK_CHARGE);
        }
        if (this.swinging) {
            return state.setAndContinue(DefaultAnimations.ATTACK_SWING);
        }
        return PlayState.STOP;
    }

    private boolean isAboutToCharge() {
        return (Byte)this.entityData.get(DATA_STATE) == 2;
    }

    private boolean isCharging() {
        return (Byte)this.entityData.get(DATA_STATE) == 3;
    }

    private boolean isThrowing() {
        return (Byte)this.entityData.get(DATA_STATE) == 1;
    }

    @Override
    public void setWarmingUp() {
        this.entityData.set(DATA_STATE, (Object)2);
    }

    @Override
    public void setActuallyCharging() {
        this.entityData.set(DATA_STATE, (Object)3);
    }

    @Override
    public void resetCharging() {
        this.clearFlags();
    }

    private void clearFlags() {
        this.entityData.set(DATA_STATE, (Object)0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void setThrowing(boolean isThrowing) {
        if (isThrowing) {
            this.entityData.set(DATA_STATE, (Object)1);
        } else {
            this.clearFlags();
        }
    }
}

