/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.ChaseTargetGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModParticleTypes;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TentacledHorror
extends BaseRiftMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation GRAB_START_ANIMATION = RawAnimation.begin().thenPlay("attack.grab_start");
    private static final RawAnimation GRAB_HOLD_ANIMATION = RawAnimation.begin().thenPlay("attack.grab_hold");
    private static final RawAnimation GRAB_BREAK_ANIMATION = RawAnimation.begin().thenPlay("attack.grab_break");
    private static final RawAnimation INKING_ANIMATION = RawAnimation.begin().thenPlay("attack.ink");
    protected static final EntityDataAccessor<Byte> DATA_STATE = SynchedEntityData.defineId(TentacledHorror.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Boolean> DATA_INK_SPRAY = SynchedEntityData.defineId(TentacledHorror.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TARGET = SynchedEntityData.defineId(TentacledHorror.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private long nextInkTime = 0L;
    private LivingEntity clientSideCachedAttackTarget;

    public TentacledHorror(EntityType<? extends TentacledHorror> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.27f).add(Attributes.MAX_HEALTH, 400.0).add(Attributes.ARMOR, 4.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public static boolean isPlayerPassenger(Player player) {
        return player.getVehicle() instanceof TentacledHorror && !player.isCreative();
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation(this, (Mob)this, level){

            protected PathFinder createPathFinder(int maxVisitedNodes) {
                this.nodeEvaluator = new WalkNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                return new PathFinder(this, this.nodeEvaluator, maxVisitedNodes){

                    protected float distance(Node first, Node second) {
                        return first.distanceToXZ(second);
                    }
                };
            }
        };
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TentacleGrabGoal(this));
        this.goalSelector.addGoal(1, (Goal)new InkAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ChaseTargetGoal((PathfinderMob)this, 1.4, 48.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)AttackState.NONE.id());
        builder.define(DATA_INK_SPRAY, (Object)false);
        builder.define(DATA_ATTACK_TARGET, (Object)0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 10, this::walkIdleState));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 5, this::attackState));
    }

    public boolean hasSyncedTarget() {
        return (Integer)this.entityData.get(DATA_ATTACK_TARGET) != 0;
    }

    public void setSyncedTarget(@Nullable LivingEntity target) {
        this.entityData.set(DATA_ATTACK_TARGET, (Object)(target == null ? 0 : target.getId()));
    }

    @Nullable
    public LivingEntity getSyncedTarget() {
        if (!this.hasSyncedTarget()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(DATA_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    protected AABB makeBoundingBox() {
        return super.makeBoundingBox().inflate(0.4, 0.0, 0.4);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide) {
            if (DATA_INK_SPRAY.equals(key) && ((Boolean)this.entityData.get(DATA_INK_SPRAY)).booleanValue() && this.getSyncedTarget() != null) {
                MiscUtil.doParticleSpray((LivingEntity)this, this.getSyncedTarget(), (ParticleOptions)ModParticleTypes.HORROR_INK.get(), 50);
            } else if (DATA_ATTACK_TARGET.equals(key)) {
                this.clientSideCachedAttackTarget = null;
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypes.WITHER);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount) && this.getAttackState().isGrabbing() && (source.is(DamageTypeTags.IS_FIRE) || this.random.nextInt(8) == 0)) {
            this.setAttackState(AttackState.GRAB_BREAK);
        }
        return false;
    }

    private PlayState walkIdleState(AnimationState<TentacledHorror> state) {
        if (state.isMoving()) {
            state.setAnimation(DefaultAnimations.WALK);
            state.setControllerSpeed(1.5f);
        } else {
            state.setAnimation(DefaultAnimations.IDLE);
            state.setControllerSpeed(1.0f);
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackState(AnimationState<TentacledHorror> state) {
        return this.getAttackState().playState(state);
    }

    public AttackState getAttackState() {
        return AttackState.BY_ID.apply(((Byte)this.entityData.get(DATA_STATE)).byteValue());
    }

    public void setAttackState(AttackState state) {
        this.entityData.set(DATA_STATE, (Object)state.id());
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        float rot = Mth.wrapDegrees((float)this.yBodyRot) + 70.0f;
        double xOff = (double)Mth.cos((float)(rot * ((float)Math.PI / 180))) * 7.0;
        double zOff = (double)Mth.sin((float)(rot * ((float)Math.PI / 180))) * 7.0;
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(xOff, -4.0, zOff);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.TENTACLED_HORROR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.TENTACLED_HORROR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.TENTACLED_HORROR_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)ModSounds.TENTACLED_HORROR_STEP.get());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return distanceToClosestPlayer > 16384.0;
    }

    static class TentacleGrabGoal
    extends Goal {
        private static final int WARMUP_TIME = 40;
        private static final int COOLDOWN_TIME = 30;
        private final TentacledHorror horror;
        private LivingEntity target;
        private int warmupCounter;
        private int cooldownCounter;

        TentacleGrabGoal(TentacledHorror horror) {
            this.horror = horror;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.target = this.horror.getTarget();
            if (this.target == null) {
                return false;
            }
            return this.target.isAlive() && (this.targetInGrabRange() || this.target.getVehicle() == this.horror);
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && (this.targetInGrabRange() || this.target.getVehicle() == this.horror) && this.cooldownCounter > 0;
        }

        public void start() {
            this.cooldownCounter = TentacleGrabGoal.reducedTickDelay((int)30);
            if (this.target.getVehicle() == this.horror) {
                this.warmupCounter = 0;
                this.horror.setAttackState(AttackState.GRAB_HOLD);
            } else {
                this.warmupCounter = TentacleGrabGoal.reducedTickDelay((int)40);
                this.horror.setAttackState(AttackState.GRAB_START);
            }
        }

        public void stop() {
            this.horror.setAttackState(AttackState.NONE);
            this.target.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        }

        public void tick() {
            if (this.target.isOnFire()) {
                this.horror.setAttackState(AttackState.GRAB_BREAK);
            }
            switch (this.horror.getAttackState().ordinal()) {
                case 1: {
                    this.horror.getLookControl().setLookAt((Entity)this.target);
                    if (this.warmupCounter <= 0 || --this.warmupCounter != 0) break;
                    if (this.target != null && this.target.isAlive() && this.ableToGrab()) {
                        this.horror.setAttackState(AttackState.GRAB_HOLD);
                        this.target.startRiding((Entity)this.horror, true);
                        break;
                    }
                    this.horror.setAttackState(AttackState.GRAB_BREAK);
                    break;
                }
                case 2: {
                    if (this.target.getRandom().nextInt(20) == 0) {
                        this.horror.playSound((SoundEvent)ModSounds.TENTACLED_HORROR_SQUEEZE.get(), 1.0f, 0.8f + this.horror.random.nextFloat() * 0.4f);
                        this.target.hurt(this.target.level().damageSources().mobAttack((LivingEntity)this.horror), 8.0f);
                    }
                    if (this.horror.random.nextInt(100) == 0) {
                        this.horror.setAttackState(AttackState.GRAB_BREAK);
                        break;
                    }
                    this.target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 5, false, false));
                    this.target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 3, false, false));
                    break;
                }
                case 3: {
                    if (this.target.getVehicle() == this.horror) {
                        this.target.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                        this.target.stopRiding();
                        this.target.setOnGround(false);
                        RandomSource r = this.horror.random;
                        this.target.setDeltaMovement(new Vec3((double)(r.nextFloat() - 0.5f), (double)(r.nextFloat() * 0.2f + 0.15f), (double)(r.nextFloat() - 0.5f)).scale(10.5));
                        LivingEntity livingEntity = this.target;
                        if (livingEntity instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)livingEntity;
                            sp.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)this.target));
                        }
                        this.target.level().playSound(null, this.target.blockPosition(), (SoundEvent)ModSounds.TENTACLED_HORROR_THROW.value(), SoundSource.HOSTILE);
                    }
                    if (this.cooldownCounter <= 0 || --this.cooldownCounter != 0) break;
                    --this.cooldownCounter;
                }
            }
        }

        private boolean targetInGrabRange() {
            return this.horror.distanceToSqr((Entity)this.target) < 49.0;
        }

        private boolean ableToGrab() {
            double chance = 1.0;
            Vec3 grabPos = this.horror.getPassengerRidingPosition((Entity)this.target).add(0.0, -5.0, 0.0);
            double dist = this.target.position().distanceTo(grabPos);
            if (dist > 3.0) {
                double x = (dist - 3.0) / 8.0;
                chance -= x;
            }
            if (this.target.isCrouching()) {
                chance -= 0.1;
            }
            if (this.target.isBlocking()) {
                chance -= 0.1;
            }
            return this.horror.getRandom().nextDouble() < Math.max(0.2, chance);
        }
    }

    static class InkAttackGoal
    extends Goal {
        private static final int INK_ATTACK_TIME = 40;
        private final TentacledHorror horror;
        private LivingEntity target;
        private Vec3 inkTarget;
        private int tickCounter;

        public InkAttackGoal(TentacledHorror horror) {
            this.horror = horror;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.target = this.horror.getTarget();
            if (this.target == null) {
                return false;
            }
            return this.target.isAlive() && this.horror.distanceToSqr((Entity)this.target) > 64.0 && this.target.getRandom().nextFloat() < 0.05f && (long)this.horror.tickCount > this.horror.nextInkTime;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && this.tickCounter >= 0;
        }

        public void start() {
            this.inkTarget = this.target.position();
            this.tickCounter = InkAttackGoal.reducedTickDelay((int)40);
            this.horror.getNavigation().stop();
            this.horror.setAttackState(AttackState.INKING);
            this.horror.setSyncedTarget(this.target);
        }

        public void stop() {
            this.horror.setAttackState(AttackState.NONE);
            this.horror.setSyncedTarget(null);
            this.horror.entityData.set(DATA_INK_SPRAY, (Object)false);
            this.horror.nextInkTime = (long)this.horror.tickCount + 40L;
        }

        public void tick() {
            this.horror.getLookControl().setLookAt((Entity)this.target);
            --this.tickCounter;
            if (this.tickCounter == 10) {
                this.horror.entityData.set(DATA_INK_SPRAY, (Object)true);
            } else if (this.tickCounter == 6) {
                this.inkTarget = this.inkTarget.lerp(this.target.position(), 0.7);
                AreaEffectCloud cloud = new AreaEffectCloud(this.target.level(), this.inkTarget.x, this.inkTarget.y, this.inkTarget.z);
                cloud.setPotionContents(new PotionContents(Optional.empty(), Optional.of(-16777216), List.of()));
                cloud.setOwner((LivingEntity)this.horror);
                cloud.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
                cloud.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 0));
                cloud.setRadius(4.0f);
                cloud.setDuration(150);
                cloud.setRadiusOnUse(-0.5f);
                cloud.setWaitTime(20);
                cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
                this.horror.level().playSound(null, BlockPos.containing((Position)this.inkTarget), SoundEvents.SLIME_JUMP, SoundSource.HOSTILE, 1.0f, 0.6f);
                this.horror.level().addFreshEntity((Entity)cloud);
            }
        }
    }

    public static enum AttackState {
        NONE(null),
        GRAB_START(GRAB_START_ANIMATION, 1.25f),
        GRAB_HOLD(GRAB_HOLD_ANIMATION),
        GRAB_BREAK(GRAB_BREAK_ANIMATION),
        INKING(INKING_ANIMATION, 2.0f);

        private final RawAnimation animation;
        private final float controllerSpeed;
        static final IntFunction<AttackState> BY_ID;

        private AttackState(RawAnimation animation) {
            this(animation, 1.0f);
        }

        private AttackState(RawAnimation animation, float controllerSpeed) {
            this.animation = animation;
            this.controllerSpeed = controllerSpeed;
        }

        byte id() {
            return (byte)this.ordinal();
        }

        PlayState playState(AnimationState<TentacledHorror> aState) {
            if (aState == null || this == NONE) {
                return PlayState.STOP;
            }
            aState.setControllerSpeed(this.controllerSpeed);
            return aState.setAndContinue(this.animation);
        }

        boolean isGrabbing() {
            return this == GRAB_HOLD || this == GRAB_START;
        }

        static {
            BY_ID = ByIdMap.continuous(AttackState::id, (Object[])AttackState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @EventBusSubscriber(modid="ftboceanmobs")
    public static class Listener {
        @SubscribeEvent
        public static void onHurt(LivingIncomingDamageEvent event) {
            if (event.getEntity().getVehicle() instanceof TentacledHorror) {
                event.setAmount(event.getAmount() * 1.25f);
            }
        }
    }
}

