/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity.riftweaver;

import dev.ftb.mods.ftboceanmobs.Config;
import dev.ftb.mods.ftboceanmobs.entity.TumblingBlockEntity;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverBoss;
import dev.ftb.mods.ftboceanmobs.registry.ModBlocks;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChainsEncaser {
    private final LivingEntity target;
    private final int totalTickTime;
    private final List<BlockPos> positions;
    private int tickCount;
    private int posIndex;

    public ChainsEncaser(LivingEntity target, int totalTickTime) {
        this.target = target;
        this.totalTickTime = totalTickTime;
        this.posIndex = 0;
        this.tickCount = 0;
        this.positions = BlockPos.betweenClosedStream((AABB)target.getBoundingBox().inflate(1.0)).map(BlockPos::immutable).sorted(Comparator.comparingInt(Vec3i::getY)).toList();
    }

    public boolean tick(RiftWeaverBoss boss) {
        if (!this.target.isAlive()) {
            return false;
        }
        float progress = Mth.clamp((float)((float)this.tickCount / (float)this.totalTickTime), (float)0.0f, (float)1.0f);
        int tgtIndex = (int)((float)this.positions.size() * progress);
        Vec3 viewVec = boss.getViewVector(1.0f).normalize();
        for (int i = this.posIndex; i < tgtIndex; ++i) {
            float radius = boss.level().random.nextFloat() * (float)Config.arenaRadius;
            float yOff = boss.level().random.nextFloat() * 22.0f + 10.0f;
            float angle = boss.level().random.nextFloat() * ((float)Math.PI * 2);
            Vec3 launchPos = Vec3.atCenterOf((Vec3i)boss.getSpawnPos()).add((double)(Mth.cos((float)angle) * radius), (double)yOff, (double)(Mth.sin((float)angle) * radius));
            Vec3 tgtPos = Vec3.atBottomCenterOf((Vec3i)((Vec3i)this.positions.get(this.posIndex))).add(0.0, 1.0, 0.0);
            TumblingBlockEntity t = new TumblingBlockEntity(boss.level(), (LivingEntity)boss, launchPos.x, launchPos.y, launchPos.z, ModBlocks.SLUDGE_BLOCK.toStack()).setCanDropItem(false).setHitBehaviour(TumblingBlockEntity.HitBehaviour.PLACE_BLOCK_ON_ENTITY);
            t.setDeltaMovement(tgtPos.subtract(launchPos).scale(0.067));
            t.setOnGround(false);
            t.horizontalCollision = false;
            t.verticalCollision = false;
            launchPos = launchPos.add(viewVec);
            boss.level().addFreshEntity((Entity)t);
        }
        this.posIndex = tgtIndex;
        return ++this.tickCount < this.totalTickTime;
    }
}

