/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.util;

import net.minecraft.resources.ResourceLocation;

public class IdentifierUtil {
    public static boolean isValidNamespace(String namespace) {
        return namespace != null && namespace.length() > 0 && namespace.matches("[a-z0-9_.-]*");
    }

    public static boolean isValidPath(String path) {
        return path != null && path.length() > 0 && path.matches("[a-z0-9_./-]*");
    }

    public static boolean isValidIdentifier(String namespace, String path) {
        return IdentifierUtil.isValidNamespace(namespace) && IdentifierUtil.isValidPath(path);
    }

    public static boolean isValidIdentifier(String identifier) {
        String[] parts = identifier.split(":");
        return parts.length == 1 && IdentifierUtil.isValidPath(parts[0]) || parts.length == 2 && IdentifierUtil.isValidIdentifier(parts[0], parts[1]);
    }

    public static ResourceLocation withFusionNamespace(String identifier) {
        String[] parts = identifier.split(":");
        return parts.length == 1 ? ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)parts[0]) : ResourceLocation.parse((String)identifier);
    }
}

