/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.data.loot;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public class GAGBlockLoot
extends BlockLootSubProvider {
    private final Map<Block, Function<Block, LootTable.Builder>> specialLoot = Map.of();

    protected GAGBlockLoot(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(entry -> entry.getLootTable().location().getNamespace().equals("gag")).toList();
    }

    protected void generate() {
        for (Block block : this.getKnownBlocks()) {
            if (this.specialLoot.containsKey(block)) {
                this.add(block, this.specialLoot.get(block));
                continue;
            }
            this.dropSelf(block);
        }
    }
}

