/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.integration.emi;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.integration.emi.GAGEmiPlugin;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.recipe.pigment.PigmentJarFromDyeRecipe;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EmiPigmentJarFromDyeRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeColor> DYES = List.of(DyeColor.values());

    public EmiPigmentJarFromDyeRecipe() {
        super(List.of(EmiStack.of(GAGRegistry.PIGMENT_JAR), EmiStack.of((ItemLike)Items.FLINT), EmiStack.of((ItemLike)Items.MILK_BUCKET)), EmiStack.of(GAGRegistry.PIGMENT_JAR), GAGEmiPlugin.synthetic(PigmentJarFromDyeRecipe.ID));
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        return switch (slot) {
            case 0 -> new SlotWidget((EmiIngredient)EmiStack.of((ItemStack)Pigment.EMPTY.asJar()), x, y);
            case 1 -> new SlotWidget((EmiIngredient)EmiStack.of((ItemLike)Items.FLINT), x, y);
            case 2 -> new SlotWidget((EmiIngredient)EmiStack.of((ItemLike)Items.MILK_BUCKET), x, y);
            default -> {
                int s = slot - 3;
                yield new GeneratedSlotWidget(r -> {
                    DyeColor color = DYES.get(r.nextInt(DYES.size()));
                    int amount = r.nextInt(4) + 1;
                    if (s < amount) {
                        return EmiStack.of((ItemLike)DyeItem.byColor((DyeColor)color));
                    }
                    return EmiStack.EMPTY;
                }, this.unique, x, y);
            }
        };
    }

    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getJarForRecipe, this.unique, x, y);
    }

    private EmiStack getJarForRecipe(Random random) {
        DyeColor color = DYES.get(random.nextInt(DYES.size()));
        int amount = random.nextInt(4) + 1;
        return EmiStack.of((ItemStack)Pigment.forText(color).withAmount(amount * 4).asJar());
    }
}

