/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.TooltipFlag;

public class PigmentJarItem
extends GAGItem {
    public static final int MAX_AMOUNT = 64;
    public static final int DYE_AMOUNT = 4;

    public PigmentJarItem() {
        super(new Item.Properties().stacksTo(16));
    }

    public static Pigment getPigment(ItemStack stack) {
        return (Pigment)stack.getOrDefault(GAGRegistry.PIGMENT_DATA, (Object)Pigment.EMPTY);
    }

    private static boolean hasPigment(ItemStack stack) {
        return !PigmentJarItem.getPigment(stack).isEmpty();
    }

    public static boolean isNonEmptyJar(ItemStack stack) {
        return stack.is((Item)GAGRegistry.PIGMENT_JAR.get()) && PigmentJarItem.hasPigment(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        if (!PigmentJarItem.hasPigment(stack)) {
            list.add((Component)Tooltips.FLAVOUR.lang("item.gag.pigment_jar.contents.empty", new Object[0]).withStyle(ChatFormatting.ITALIC));
            GAGUtil.appendInfoTooltip(list, List.of(Tooltips.MAIN.lang("item.gag.pigment_jar.info.empty.1", new Object[0]), Tooltips.EXTRA.lang("item.gag.pigment_jar.info.empty.2", new Object[0])));
        } else {
            Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(stack));
            list.add((Component)Tooltips.FLAVOUR.lang("item.gag.pigment_jar.contents", Tooltips.asStyledValue(pigment.amount(), 32.0, Integer.toString(pigment.amount())), Component.literal((String)pigment.hex()).withStyle(s -> s.withColor(pigment.rgb()))));
            GAGUtil.appendInfoTooltip(list, List.of(Tooltips.MAIN.lang("item.gag.pigment_jar.info.filled.1", new Object[0]), Tooltips.EXTRA.lang("item.gag.pigment_jar.info.filled.2", new Object[0])));
        }
    }

    @Override
    public Collection<ItemStack> getAdditionalSubItems() {
        return (Collection)Util.make((Object)ItemStackLinkedSet.createTypeAndComponentsSet(), set -> {
            for (DyeColor color : DyeColor.values()) {
                set.add(Pigment.forText(color).asJar());
            }
        });
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        Pigment pigment = PigmentJarItem.getPigment(stack);
        if (pigment.isEmpty()) {
            return name;
        }
        return name.copy().withStyle(s -> s.withColor(pigment.rgb()));
    }
}

