/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.util.GAGUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarSplittingRecipe
extends CustomRecipe {
    public static final ResourceLocation ID = GAGUtil.id("pigment_jar_splitting");

    public PigmentJarSplittingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        boolean filled = false;
        boolean empty = false;
        for (ItemStack stack : container.items()) {
            if (!stack.is((Item)GAGRegistry.PIGMENT_JAR.get())) continue;
            if (PigmentJarItem.getPigment(stack).isEmpty()) {
                if (empty) {
                    return false;
                }
                empty = true;
                continue;
            }
            if (filled) {
                return false;
            }
            filled = true;
        }
        return filled && empty;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider reg) {
        for (ItemStack stack : container.items()) {
            Pigment pigment;
            if (!stack.is((Item)GAGRegistry.PIGMENT_JAR.get()) || (pigment = PigmentJarItem.getPigment(stack)) == null || pigment.isEmpty()) continue;
            Pigment newStack = pigment.withAmount(pigment.amount() / 2);
            return newStack.asJar().copyWithCount(2);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)GAGRegistry.PIGMENT_JAR_SPLITTING.get();
    }
}

