/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.entity;

import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.registry.GazeEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class SwordDomainProjectileEntity
extends ThrowableItemProjectile {
    public TrailPointBuilder trailPointBuilder;
    public TrailPointBuilder spinningTrailPointBuilder;
    public float spinOffset;
    protected float damage;
    protected float magicDamage;
    public int age;
    public int targetSelectionTimer;
    public int bounceCount;
    public int returnTimer;
    private List<Entity> hitEntities;
    private LivingEntity forcedTarget;
    private boolean launched = false;
    private int holdTicks = 0;
    private final int holdDuration = 20;
    private Vec3 launchVelocity = Vec3.ZERO;
    private Vec3 forwardDirection = Vec3.ZERO;
    private Vec3 initialForwardVector = Vec3.ZERO;

    public SwordDomainProjectileEntity(Level level) {
        super((EntityType)GazeEntityRegistry.SWORD_DOMAIN_PROJECTILE.get(), level);
        this.trailPointBuilder = TrailPointBuilder.create((int)60);
        this.spinningTrailPointBuilder = TrailPointBuilder.create((int)8);
        this.spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
        this.hitEntities = new ArrayList<Entity>();
        this.noPhysics = false;
        this.setNoGravity(true);
    }

    public SwordDomainProjectileEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = true;
    }

    public void setData(LivingEntity owner, float damage, float magicDamage) {
        this.setOwner((Entity)owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
    }

    public void setInitialVelocity(Vec3 velocity) {
        this.launchVelocity = velocity.scale(0.5);
        this.forwardDirection = this.launchVelocity.normalize();
        this.initialForwardVector = this.getForwardVector();
    }

    protected Item getDefaultItem() {
        return (Item)GazeMod.SPIRIT_SABER.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.damage != 0.0f) {
            compound.putFloat("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.targetSelectionTimer != 0) {
            compound.putInt("secondBounceDelay", this.targetSelectionTimer);
        }
        if (this.bounceCount != 0) {
            compound.putInt("bounceCount", this.bounceCount);
        }
        if (this.returnTimer != 0) {
            compound.putInt("returnTimer", this.returnTimer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
        this.magicDamage = compound.getFloat("magicDamage");
        this.age = compound.getInt("age");
        this.targetSelectionTimer = compound.getInt("secondBounceDelay");
        this.bounceCount = compound.getInt("bounceCount");
        this.returnTimer = compound.getInt("returnTimer");
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_HEAVY_IMPACT.get()), (float)2.0f, (float)1.0f);
        if (this.level().isClientSide) {
            this.spawnBlockHitParticles();
        }
        this.launched = false;
        this.holdTicks = -1000;
        float factor = RandomHelper.randomBetween((RandomSource)this.random, (float)0.5f, (float)0.75f);
        this.setPos(this.position().subtract(this.launchVelocity.scale((double)factor)));
    }

    protected void onHitEntity(EntityHitResult result) {
        float arcaneResonance = 1.0f;
        Entity hitEntity = result.getEntity();
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)owner;
            if (hitEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitEntity;
                if (attacker.getAttribute((Holder)MalumAttributes.ARCANE_RESONANCE) != null) {
                    arcaneResonance = (float)attacker.getAttribute((Holder)MalumAttributes.ARCANE_RESONANCE).getValue();
                }
            }
        }
        if (this.hitEntities.contains(result.getEntity())) {
            return;
        }
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)var3;
            Entity target = this.getOwner();
            if (target instanceof LivingEntity) {
                target = result.getEntity();
                target.invulnerableTime = 0;
                DamageSource source = DamageTypeHelper.create((Level)this.level(), (ResourceKey)MalumDamageTypes.VOODOO, (Entity)this, (Entity)this.getOwner());
                boolean success = target.hurt(source, 1.0f);
                if (success && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    ResourceKey physicalDamageType = MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO;
                    ResourceKey magicDamageType = MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO;
                    float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)1.5f, (float)2.0f);
                    SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_SWEEP.get()), (float)2.0f, (float)pitch);
                    int comboDelay = 1;
                    ItemStack stack = this.getItem();
                    if (stack.is((Item)GazeMod.ASTRAL_SPLINTERED_WORLD.get())) {
                        this.damage = this.magicDamage * 2.0f;
                    }
                    WorldEventHandler.addWorldEvent((Level)level, (WorldEventInstance)new DelayedDamageWorldEvent(target).setAttacker(this.getOwner()).setDamageData(physicalDamageType, this.damage / 2.0f * arcaneResonance, magicDamageType, 0.0f, comboDelay).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.SCYTHE_SLASH, new MalumNetworkedParticleEffectColorData((SpiritLike[])new SpiritHolder[]{MalumSpiritTypes.AERIAL_SPIRIT})).setSound((Holder)MalumSoundEvents.SCYTHE_CUT, 1.75f, 1.5f, 0.7f));
                }
            }
        }
        this.hitEntities.add(result.getEntity());
    }

    protected boolean canHitEntity(Entity pTarget) {
        return false;
    }

    protected boolean canHitEntityStupidCopy(Entity pTarget) {
        if (pTarget.equals((Object)this.getOwner())) {
            return false;
        }
        if (pTarget instanceof SwordDomainProjectileEntity) {
            return false;
        }
        if (!this.launched) {
            return false;
        }
        return this.hitEntities.contains(pTarget) ? false : super.canHitEntity(pTarget);
    }

    public void tick() {
        ++this.age;
        if (this.age > 160) {
            this.discard();
            return;
        }
        if (!this.launched) {
            ++this.holdTicks;
            if (this.holdTicks >= this.holdDuration) {
                this.launched = true;
                this.setDeltaMovement(this.launchVelocity);
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        if (this.level().isClientSide) {
            this.spawnParticles();
        }
        Vec3 deltaMovement = this.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(deltaMovement.length()));
        ++this.returnTimer;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)var3;
            AABB aabb = this.getBoundingBox().inflate(0.75);
            for (Entity target : level.getEntities((Entity)this, aabb, this::canHitEntityStupidCopy)) {
                this.onHitEntity(new EntityHitResult(target));
            }
        } else {
            Vec3 projectileDirection = this.getDeltaMovement().normalize();
            float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(projectileDirection);
            float offsetScale = Mth.clampedLerp((float)0.1f, (float)0.3f, (float)this.getVisualEffectScalar());
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.getPosition(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.add(left.scale(xOffset)).add(up.scale(zOffset)));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
        }
        if (this.launched) {
            super.tick();
        }
    }

    @NotNull
    public SoundSource getSoundSource() {
        return this.getOwner() != null ? this.getOwner().getSoundSource() : SoundSource.PLAYERS;
    }

    public void shootFromRotation(@NotNull Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.sin((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, innacuracy);
    }

    public void jumbleMovement(float weight) {
        float randomRotationX = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationY = (float)(Math.random() * Math.PI * 2.0);
        float randomRotationZ = (float)(Math.random() * Math.PI * 2.0);
        Vec3 motion = this.getDeltaMovement();
        Vec3 newMotion = motion.xRot(randomRotationX).yRot(randomRotationY);
        double cosZ = Math.cos(randomRotationZ);
        double sinZ = Math.sin(randomRotationZ);
        double x = newMotion.x * cosZ - newMotion.y * sinZ;
        double y = newMotion.x * sinZ + newMotion.y * cosZ;
        double z = newMotion.z;
        Vec3 lerp = motion.lerp(new Vec3(x, y, z), (double)weight);
        this.setDeltaMovement(lerp.normalize().scale(motion.length()));
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 8) {
            effectScalar = (float)this.age / 8.0f;
        }
        return effectScalar;
    }

    Vec3 getForwardVector() {
        Vec3 motion = this.getDeltaMovement();
        if (motion.lengthSqr() > 1.0E-7) {
            return motion.normalize();
        }
        float pitchRad = (float)Math.toRadians(this.getXRot());
        float yawRad = (float)Math.toRadians(this.getYRot());
        double x = Math.sin(yawRad) * Math.cos(pitchRad);
        double y = Math.sin(pitchRad);
        double z = Math.cos(yawRad) * Math.cos(pitchRad);
        return new Vec3(x, y, z).normalize();
    }

    private Vec3 getPerpendicularVector(Vec3 forward) {
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 perpendicular = forward.cross(up);
        if (perpendicular.lengthSqr() < 1.0E-6) {
            up = new Vec3(1.0, 0.0, 0.0);
            perpendicular = forward.cross(up);
        }
        return perpendicular.normalize();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        SpiritHolder spirit = MalumSpiritTypes.ELDRITCH_SPIRIT;
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)this.position(), (SpiritLike)spirit);
        lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(5.0f).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        float count = 1.0f + (float)this.getDeltaMovement().length() * 3.0f;
        Vec3 movement = this.launched ? this.getDeltaMovement().normalize() : this.getForwardVector();
        Vec3 rotated = new Vec3(movement.z(), movement.y(), movement.x());
        int i = 0;
        while ((float)i < count) {
            Vec3 position = this.getPosition((float)i / count);
            if (this.age < 20 && Config.fancyParticles) {
                WorldParticleBuilder.create((Supplier)MalumParticles.SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)movement)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.7f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.ARCANE_SPIRIT.createColorData().build()).setLifetime(Math.min(5 + this.age * 2, 20)).addTickActor(behavior).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.9f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.6f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).spawn(level, position.x, position.y, position.z);
                WorldParticleBuilder.create((Supplier)MalumParticles.SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)movement)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.7f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.ARCANE_SPIRIT.createColorData().build()).setLifetime(Math.min(5 + this.age * 2, 20)).addTickActor(behavior).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * scalar), (float)(0.3f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.AERIAL_SPIRIT.createColorData().build()).spawn(level, position.x, position.y, position.z);
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnBlockHitParticles() {
        Level level = this.level();
        if (level == null) {
            return;
        }
        float scalar = 1.0f;
        SpiritHolder spirit = MalumSpiritTypes.AERIAL_SPIRIT;
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale(0.85));
        for (int i = 0; i < 3; ++i) {
            WorldParticleBuilder.create((Supplier)MalumParticles.SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)Vec3.ZERO)).setColorData((ColorParticleDataWrapper)spirit.createColorData().build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.8f, (float)0.0f, (float)0.0f).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.7f).build()).setLifetime(8 + RandomHelper.randomBetween((RandomSource)this.random, (int)0, (int)6)).addTickActor(slowDown).enableNoClip().enableForcedSpawn().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).spawn(level, this.position().x, this.position().y, this.position().z);
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return false;
    }
}

