/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.geas.domain;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.entity.SaberProjectileEntity;
import com.strawberry.gaze.common.entity.SwordDomainProjectileEntity;
import com.strawberry.gaze.registry.GazeGeasEffectTypeRegistry;
import com.strawberry.gaze.registry.GazeParticles;
import com.strawberry.gaze.registry.GazeTags;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class SwordDomainGeas
extends GeasEffect {
    private static final ResourceLocation SWORD_INCREASE_ID = GazeMod.gazePath("sword_domain_increase");
    private static final ResourceLocation NO_SWORD_DECREASE_ID = GazeMod.gazePath("sword_domain_decrease");
    private static final ResourceLocation NO_SWORD_MAGIC_DECREASE_ID = GazeMod.gazePath("sword_domain_magic_decrease");
    public static final int DOMAIN_RANGE = 8;
    private static final int MAX_SUMMONS = 2;
    private int swordSummons = 0;

    public SwordDomainGeas() {
        super((GeasEffectType)GazeGeasEffectTypeRegistry.DOMAIN_OF_SWORDS.get());
    }

    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect((String)"sword_purist", (Object[])new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"sword_summon", (Object[])new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect((String)"sword_energy", (Object[])new Object[0]));
    }

    public void outgoingDamageEvent(LivingIncomingDamageEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (attacker.level().isClientSide) {
            return;
        }
        if (this.swordSummons > 2) {
            return;
        }
        if (event.getSource().getDirectEntity() instanceof SaberProjectileEntity) {
            return;
        }
        if (!event.getContainer().getSource().is(DamageTypes.PLAYER_ATTACK)) {
            return;
        }
        if (event.getSource().getEntity() != attacker) {
            return;
        }
        if (event.getSource().getWeaponItem() == null) {
            return;
        }
        if (!ItemStack.matches((ItemStack)event.getSource().getWeaponItem(), (ItemStack)attacker.getMainHandItem())) {
            return;
        }
        if (!this.isSword(event.getSource().getWeaponItem())) {
            return;
        }
        if (!attacker.hasEffect(GazeMod.SWORD_DOMAIN)) {
            return;
        }
        MobEffectInstance effect = attacker.getEffect(GazeMod.SWORD_DOMAIN);
        if (effect == null) {
            return;
        }
        if (attacker.getRandom().nextFloat() < 0.05f) {
            EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)attacker, (int)1, (int)3);
        }
        Level level = attacker.level();
        RandomSource random = level.getRandom();
        int projectileCount = effect.getAmplifier();
        for (int i = 0; i < projectileCount; ++i) {
            Vec3 spawnPos = attacker.position().add((random.nextDouble() - 0.5) * 8.0 * 2.0, random.nextDouble() * 5.0 + 1.0, (random.nextDouble() - 0.5) * 8.0 * 2.0);
            if (target == null) continue;
            this.fireProjectileAtTarget(attacker, stack, level, spawnPos, target);
        }
        ++this.swordSummons;
    }

    private void fireProjectileAtTarget(LivingEntity player, ItemStack stack, Level level, Vec3 spawnPos, LivingEntity target) {
        float physicalDamage = (float)player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        SwordDomainProjectileEntity projectile = new SwordDomainProjectileEntity(level, spawnPos.x, spawnPos.y, spawnPos.z);
        projectile.setData(player, physicalDamage, magicDamage);
        projectile.setItem(stack);
        ItemStack mainhandCopy = player.getMainHandItem().copy();
        projectile.setItem(mainhandCopy);
        Vec3 direction = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(spawnPos).normalize();
        projectile.shoot(direction.x, direction.y, direction.z, 1.75f, 0.0f);
        projectile.setInitialVelocity(projectile.getDeltaMovement());
        SoundHelper.playSound((Entity)player, (SoundEvent)SoundEvents.ARROW_SHOOT, (float)0.5f, (float)RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.5f, (float)1.0f));
        level.addFreshEntity((Entity)projectile);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        this.addAttributeModifier(modifiers, (Holder)LodestoneAttributes.MAGIC_PROFICIENCY, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return modifiers;
    }

    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        boolean holdingSword;
        boolean bl = holdingSword = this.isSword(entity.getMainHandItem()) || this.isSword(entity.getOffhandItem());
        if (holdingSword && event.getEntity().level().isClientSide) {
            this.spawnGeasHaloParticles(entity.level(), entity, 1.0f);
        }
        if (entity.level().isClientSide) {
            return;
        }
        AttributeInstance attackDamage = entity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attackDamage == null) {
            return;
        }
        attackDamage.removeModifier(SWORD_INCREASE_ID);
        attackDamage.removeModifier(NO_SWORD_DECREASE_ID);
        if (holdingSword) {
            if (this.swordSummons > 0) {
                --this.swordSummons;
            }
            attackDamage.addTransientModifier(new AttributeModifier(SWORD_INCREASE_ID, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            if (entity.hasEffect(GazeMod.SWORD_DOMAIN)) {
                MobEffectInstance currentEffect = entity.getEffect(GazeMod.SWORD_DOMAIN);
                entity.addEffect(new MobEffectInstance(GazeMod.SWORD_DOMAIN, 20, currentEffect != null ? currentEffect.getAmplifier() : 0, false, false));
            } else {
                entity.addEffect(new MobEffectInstance(GazeMod.SWORD_DOMAIN, 20, 0, false, false));
            }
        } else {
            if (attackDamage.getValue() > 2.0) {
                attackDamage.addTransientModifier(new AttributeModifier(NO_SWORD_DECREASE_ID, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            entity.removeEffect(GazeMod.SWORD_DOMAIN);
        }
    }

    public void removeAttributeModifiers(LivingEntity entity) {
        super.removeAttributeModifiers(entity);
        entity.removeEffect(GazeMod.SWORD_DOMAIN);
        AttributeInstance attackDamage = entity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attackDamage != null) {
            attackDamage.removeModifier(SWORD_INCREASE_ID);
            attackDamage.removeModifier(NO_SWORD_DECREASE_ID);
            attackDamage.removeModifier(NO_SWORD_MAGIC_DECREASE_ID);
        }
    }

    private boolean isSword(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof SwordItem || stack.is(GazeTags.SWORDS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnGeasHaloParticles(Level pLevel, LivingEntity pLivingEntity, float pct) {
        if (Config.fancyParticles) {
            Vec3 center = pLivingEntity.position().add(0.0, (double)pLivingEntity.getBbHeight() * 0.9, 0.0);
            float yawRad = (float)Math.toRadians(pLivingEntity.getYRot());
            Vec3 forwardHoriz = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).normalize();
            double behindDistance = 0.5;
            Vec3 behind = center.subtract(forwardHoriz.scale(behindDistance));
            Vec3 right = new Vec3(forwardHoriz.z, 0.0, -forwardHoriz.x).normalize();
            double sideOffset = 0.05;
            Vec3 leftWingPos = behind.add(right.scale(sideOffset)).add(0.0, 0.15, 0.0);
            Vec3 leftDir = forwardHoriz.scale(-0.7).add(right.scale(0.0)).normalize();
            WorldParticleBuilder.create(GazeParticles.SWORD_HALO).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)leftDir)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.33f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(2).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, leftWingPos.x, leftWingPos.y, leftWingPos.z);
            WorldParticleBuilder.create(GazeParticles.SWORD_HALO).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)leftDir)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.23f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.9f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(2).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).spawn(pLevel, leftWingPos.x, leftWingPos.y, leftWingPos.z);
        }
    }
}

