/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.rings;

import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import top.theillusivec4.curios.api.SlotContext;

public class CurioMeditationRing
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    private static final ResourceLocation MEDITATION_RING_ID = GazeMod.gazePath("meditation_ring");
    private final WeakHashMap<Player, Vec3> lastPositions = new WeakHashMap();
    private final WeakHashMap<Player, Long> cooldownExpirations = new WeakHashMap();
    private static final long COOLDOWN_MS = 5000L;

    public CurioMeditationRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"meditation_ring", (Object[])new Object[0]));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack curioStack) {
        super.onUnequip(slotContext, newStack, curioStack);
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        AttributeInstance attributeInstance = player.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE);
        if (attributeInstance == null) {
            return;
        }
        if (attributeInstance.getModifier(MEDITATION_RING_ID) != null) {
            attributeInstance.removeModifier(MEDITATION_RING_ID);
        }
        this.lastPositions.remove(player);
        this.cooldownExpirations.remove(player);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AttributeInstance attributeInstance;
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        long now = System.currentTimeMillis();
        Long cooldownExpiry = this.cooldownExpirations.get(player);
        boolean onCooldown = cooldownExpiry != null && cooldownExpiry > now;
        Vec3 currentPos = player.position();
        Vec3 lastPos = this.lastPositions.get(player);
        boolean isMoving = false;
        if (lastPos != null) {
            double distanceSq = currentPos.distanceToSqr(lastPos);
            isMoving = distanceSq > 0.001;
        }
        this.lastPositions.put(player, currentPos);
        if (!isMoving) {
            boolean bl = isMoving = player.getDeltaMovement().horizontalDistanceSqr() > 0.001;
        }
        if ((attributeInstance = player.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE)) == null) {
            return;
        }
        AttributeModifier existingModifier = attributeInstance.getModifier(MEDITATION_RING_ID);
        if (isMoving) {
            if (!onCooldown) {
                this.cooldownExpirations.put(player, now + 5000L);
            }
            if (existingModifier != null) {
                attributeInstance.removeModifier(MEDITATION_RING_ID);
            }
            return;
        }
        if (onCooldown) {
            if (existingModifier != null) {
                attributeInstance.removeModifier(MEDITATION_RING_ID);
            }
            return;
        }
        if (existingModifier == null) {
            attributeInstance.addTransientModifier(new AttributeModifier(MEDITATION_RING_ID, 5.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (player.level().getRandom().nextFloat() < 0.17f) {
            RandomSource random = player.level().getRandom();
            double angle = random.nextDouble() * Math.PI;
            double dx = Math.cos(angle) * 1.0;
            double dz = Math.sin(angle) * 1.0;
            double dy = 0.5 + random.nextDouble() * 1.0;
            Vec3 spawnPos = player.position().add(dx, dy, dz);
            if (player.level().isClientSide) {
                this.spawnChargeParticles(player.level(), (LivingEntity)player, spawnPos, stack, 1.0f);
            }
            if (((StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES)).getStaffChargeDebt() > 1) {
                ((StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES)).reduceStaffChargeCooldown((LivingEntity)player, 20);
                SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.STAFF_CHARGED.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)random, (float)0.8f, (float)0.6f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    void spawnChargeParticles(Level pLevel, LivingEntity entity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.random;
        WorldParticleBuilder.create((Supplier)MalumParticles.STAR).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)entity.getLookAngle().normalize())).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)-0.0f, (float)-0.5f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(new Vec3(0.0, 0.2, 0.0)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.ARCANE_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(10).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(entity.level(), pos.x, pos.y, pos.z);
    }
}

