/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.runes;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.MadnessRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.SoulWardDamageEvent;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import top.theillusivec4.curios.api.SlotContext;

public class RuneEirItem
extends MadnessRuneCurioItem
implements IMalumEventResponder {
    private static final ResourceLocation EIR_BOOST_ID = GazeMod.gazePath("eir_rune");
    private static final WeakHashMap<LivingEntity, Integer> boostTimers = new WeakHashMap();

    public RuneEirItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.AERIAL_SPIRIT);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"rune_of_eir", (Object[])new Object[0]));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        AttributeInstance attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE);
        if (attribute != null) {
            attribute.removeModifier(EIR_BOOST_ID);
        }
        boostTimers.remove(entity);
    }

    public void soulWardDamageEvent(SoulWardDamageEvent event, LivingEntity entity, ItemStack stack) {
        AttributeInstance attribute;
        if (event.getSoulWardHandler().isDepleted() && (attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE)) != null && attribute.getModifier(EIR_BOOST_ID) == null) {
            attribute.addTransientModifier(new AttributeModifier(EIR_BOOST_ID, 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            boostTimers.put(entity, 200);
            RandomSource random = entity.level().getRandom();
            SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.SOUL_WARD_GROW.get()), (float)0.3f, (float)Mth.nextFloat((RandomSource)random, (float)0.6f, (float)0.8f));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (boostTimers.containsKey(slotContext.entity()) && slotContext.entity().level().isClientSide) {
            this.spawnChargeParticles(slotContext.entity().level(), slotContext.entity(), slotContext.entity().position(), stack, 1.0f);
        }
        boostTimers.entrySet().removeIf(entry -> {
            LivingEntity entity = (LivingEntity)entry.getKey();
            int timeLeft = (Integer)entry.getValue() - 1;
            if (timeLeft <= 0) {
                AttributeInstance attribute = entity.getAttribute((Holder)MalumAttributes.SOUL_WARD_RECOVERY_RATE);
                if (attribute != null) {
                    attribute.removeModifier(EIR_BOOST_ID);
                }
                return true;
            }
            entry.setValue(timeLeft);
            return false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    void spawnChargeParticles(Level level, LivingEntity entity, Vec3 pos, ItemStack stack, float pct) {
        RandomSource random = level.random;
        double centerY = entity.getY() + (double)entity.getBbHeight() * 0.5;
        double radius = 0.5;
        int particleCount = 1;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.nextDouble() * (Math.PI * 2);
            double r = radius + (random.nextDouble() * 0.2 - 0.1);
            double dx = Math.cos(angle) * r;
            double dz = Math.sin(angle) * r;
            double dy = (random.nextDouble() - 0.5) * 0.4;
            Vec3 spawnPos = new Vec3(entity.getX() + dx, centerY + dy, entity.getZ() + dz);
            WorldParticleBuilder.create((Supplier)MalumParticles.STRANGE_SMOKE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)entity.getLookAngle().normalize())).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)0.0f, (float)-0.5f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.2f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(new Vec3(0.0, 0.07, 0.0)).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.UMBRAL_COLORS().createColorData()).enableForcedSpawn().setLifeDelay(2).setLifetime(20).enableNoClip().setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, spawnPos.x, spawnPos.y, spawnPos.z);
        }
    }
}

