/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.attack.SunderingAnchorSlashParticleEffect;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.item.LodestoneCombatItem;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class AstralSplinteredWorld
extends LodestoneCombatItem
implements IMalumEventResponder,
ISpiritAffiliatedItem {
    public static final SpiritHolder[] SPIRITS = new SpiritHolder[]{MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT};

    public AstralSplinteredWorld(Tier tier, float magicDamage, LodestoneItemProperties properties) {
        super(tier, -2.0f, -1.0f, properties.component(DataComponents.TOOL, (Object)AstralSplinteredWorld.createToolProperties(tier, (TagKey<Block>)MalumTags.BlockTags.MINEABLE_WITH_KNIFE)).mergeAttributes(ItemAttributeModifiers.builder().add((Holder)LodestoneAttributes.MAGIC_DAMAGE, new AttributeModifier(LodestoneAttributes.MAGIC_DAMAGE.getId(), (double)magicDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public static SpiritHolder getWorldSpirit() {
        return SPIRITS[MalumMod.RANDOM.nextInt(SPIRITS.length)];
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.equals((Object)Enchantments.BREACH)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public SpiritHolder getDefiningSpiritType() {
        return AstralSplinteredWorld.getWorldSpirit();
    }

    public static Tool createToolProperties(Tier tier, TagKey<Block> blocks) {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f), Tool.Rule.deniesDrops((TagKey)tier.getIncorrectBlocksForDrops()), Tool.Rule.minesAndDrops(blocks, (float)tier.getSpeed())), 1.0f, 2);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            RandomSource random = level2.random;
            if (source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) {
                boolean isDay;
                float damage = event.getNewDamage();
                long timeOfDay = level2.getDayTime() % 24000L;
                boolean bl = isDay = timeOfDay >= 0L && timeOfDay < 13000L;
                if (isDay) {
                    damage *= 1.3f;
                }
                if (target.isAlive()) {
                    WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(0.0f, damage, 1).setSound((Holder)MalumSoundEvents.TYRVING_SLASH, 1.25f, 2.0f, 0.7f));
                }
                event.setNewDamage(damage);
                float pitch = RandomHelper.randomBetween((RandomSource)level2.getRandom(), (float)0.75f, (float)2.0f);
                SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.SUNDERING_ANCHOR_SWING.get()), (float)2.0f, (float)pitch);
                MalumParticleEffectTypes.TYRVING_SLASH.createEffect().originatesFrom((Entity)attacker).forwardOffset(1.5f).horizontalOffset(0.3f).upwardOffset(-0.2f).color((SpiritLike[])SPIRITS).customData((WeaponParticleEffectType.WeaponParticleEffectData)new SunderingAnchorSlashParticleEffect.SunderingAnchorSlashEffectData(1)).randomSlashRotation(random).spawn(level2);
            }
        }
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            TemporarilyDisabledItem.Disabled disabled = (TemporarilyDisabledItem.Disabled)pStack.get((Supplier)MalumDataComponents.DISABLED);
            if (disabled != null) {
                long time = disabled.time();
                if (pLevel.getGameTime() >= time) {
                    AstralSplinteredWorld.enable(player, pSlotId);
                    return;
                }
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public static void disable(ServerPlayer player, int slot, Supplier<Item> disabledItemType) {
        Inventory inventory = player.getInventory();
        ItemStack original = inventory.getItem(slot);
        if (original.isEmpty()) {
            return;
        }
        ItemStack disabled = disabledItemType.get().getDefaultInstance();
        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)original);
        EnchantmentHelper.setEnchantments((ItemStack)disabled, (ItemEnchantments)enchants);
        long disableUntil = player.level().getGameTime() + 360L;
        disabled.set((Supplier)MalumDataComponents.DISABLED, (Object)new TemporarilyDisabledItem.Disabled(original.copy(), disableUntil));
        inventory.setItem(slot, disabled);
    }

    public static void enable(ServerPlayer player, int slot) {
        ItemStack original;
        Inventory inventory = player.getInventory();
        ItemStack disabledItem = inventory.getItem(slot);
        TemporarilyDisabledItem.Disabled disabled = (TemporarilyDisabledItem.Disabled)disabledItem.get((Supplier)MalumDataComponents.DISABLED);
        if (disabled != null && !(original = disabled.item()).isEmpty()) {
            inventory.setItem(slot, original);
        }
    }

    public static void applyCooldown(ItemStack stack, Player player) {
        if (!player.isCreative()) {
            int cooldown = 200;
            player.getCooldowns().addCooldown(stack.getItem(), cooldown);
        }
    }

    public record Disabled(ItemStack item, long time) {
        public static Codec<TemporarilyDisabledItem.Disabled> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(TemporarilyDisabledItem.Disabled::item), (App)Codec.LONG.fieldOf("time").forGetter(TemporarilyDisabledItem.Disabled::time)).apply((Applicative)instance, TemporarilyDisabledItem.Disabled::new));
        public static StreamCodec<RegistryFriendlyByteBuf, TemporarilyDisabledItem.Disabled> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, p -> p.item(), (StreamCodec)ByteBufCodecs.VAR_LONG, p -> p.time(), TemporarilyDisabledItem.Disabled::new);
    }
}

