/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GazeGreaterEarthenRiteEffect
extends SpiritRiteBlockEffect {
    public GazeGreaterEarthenRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.GREATER_RITE});
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState blockState, BlockPos pos, float v) {
        BlockPos center = activator.blockPosition();
        int radius = Math.max(0, (int)v);
        AABB effectBounds = new AABB((double)((float)center.getX() - v), (double)((float)center.getY() - v), (double)((float)center.getZ() - v), (double)((float)center.getX() + v), (double)((float)center.getY() + v), (double)((float)center.getZ() + v));
        List items = level.getEntitiesOfClass(ItemEntity.class, effectBounds, item -> item.getItem().is(ItemTags.VILLAGER_PLANTABLE_SEEDS));
        int seedsPlanted = 0;
        int maxSeeds = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius && seedsPlanted < maxSeeds && !items.isEmpty(); ++dz) {
                BlockPos above;
                BlockPos targetPos = center.offset(dx, 0, dz);
                BlockState groundState = level.getBlockState(targetPos);
                if (!(groundState.getBlock() instanceof FarmBlock) || !level.getBlockState(above = targetPos.above()).isAir()) continue;
                ItemEntity seedEntity = null;
                for (ItemEntity itemEntity : items) {
                    BlockItem blockItem;
                    Block block;
                    ItemStack stack = itemEntity.getItem();
                    Item item2 = stack.getItem();
                    if (!(item2 instanceof BlockItem) || !((block = (blockItem = (BlockItem)item2).getBlock()) instanceof CropBlock)) continue;
                    CropBlock crop = (CropBlock)block;
                    seedEntity = itemEntity;
                    level.setBlockAndUpdate(above, crop.defaultBlockState());
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        itemEntity.discard();
                    }
                    ++seedsPlanted;
                    this.createEffect(level, above, new SpiritLike[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT});
                    break;
                }
                if (seedEntity == null || !seedEntity.getItem().isEmpty()) continue;
                items.remove(seedEntity);
            }
        }
    }
}

