/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GazeGreaterSacredRiteEffect
extends SpiritRiteBlockEffect {
    public GazeGreaterSacredRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.GREATER_RITE});
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState blockState, BlockPos pos, float v) {
        double x = activator.getX();
        double y = activator.getY();
        double z = activator.getZ();
        AABB effectBounds = new AABB(x - (double)v, y - (double)v, z - (double)v, x + (double)v, y + (double)v, z + (double)v);
        List items = level.getEntitiesOfClass(ItemEntity.class, effectBounds);
        int melonCount = 0;
        int carrotCount = 0;
        int malignantLeadCount = 0;
        for (ItemEntity itemEntity : items) {
            ItemStack stack = itemEntity.getItem();
            Item item = stack.getItem();
            if (item == Items.MELON_SLICE) {
                melonCount += stack.getCount();
                continue;
            }
            if (item == Items.CARROT) {
                carrotCount += stack.getCount();
                continue;
            }
            if (!item.equals(MalumItems.MALIGNANT_LEAD.get())) continue;
            malignantLeadCount += stack.getCount();
        }
        boolean didTransform = false;
        if (melonCount >= 8 || carrotCount >= 8) {
            Item targetItem = melonCount >= 8 ? Items.MELON_SLICE : Items.CARROT;
            Item resultItem = melonCount >= 8 ? Items.GLISTERING_MELON_SLICE : Items.GOLDEN_CARROT;
            int toConsume = 8;
            for (ItemEntity itemEntity : items) {
                ItemStack stack = itemEntity.getItem();
                if (stack.getItem() != targetItem || toConsume <= 0) continue;
                int consumeAmount = Math.min(toConsume, stack.getCount());
                stack.shrink(consumeAmount);
                toConsume -= consumeAmount;
                if (!stack.isEmpty()) continue;
                itemEntity.discard();
            }
            level.addFreshEntity((Entity)new ItemEntity((Level)level, x, y + 1.0, z, new ItemStack((ItemLike)resultItem)));
            didTransform = true;
        }
        if (malignantLeadCount > 0) {
            int toConvert = malignantLeadCount;
            for (ItemEntity itemEntity : items) {
                ItemStack stack = itemEntity.getItem();
                if (!stack.getItem().equals(MalumItems.MALIGNANT_LEAD.get()) || toConvert <= 0) continue;
                int convertAmount = Math.min(toConvert, stack.getCount());
                stack.shrink(convertAmount);
                toConvert -= convertAmount;
                if (stack.isEmpty()) {
                    itemEntity.discard();
                }
                level.addFreshEntity((Entity)new ItemEntity((Level)level, x, y + 1.0, z, new ItemStack((ItemLike)MalumItems.CTHONIC_GOLD.get(), convertAmount)));
            }
            didTransform = true;
        }
        if (didTransform) {
            this.createEffect(level, activator.blockPosition(), new SpiritLike[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT});
        }
    }
}

