/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GazeGreaterWickedCorruptedRiteEffect
extends SpiritRiteBlockEffect {
    public GazeGreaterWickedCorruptedRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.GREATER_RITE});
    }

    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity activator, BlockState state, BlockPos pos, float v) {
        RandomSource random = level.random;
        if (random.nextBoolean()) {
            return;
        }
        double x = activator.getX();
        double y = activator.getY();
        double z = activator.getZ();
        AABB area = new AABB(x - (double)v, y - (double)v, z - (double)v, x + (double)v, y + (double)v, z + (double)v);
        BlockPos.betweenClosedStream((AABB)area).forEach(blockPos -> {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerEntity = (SpawnerBlockEntity)blockEntity;
                BaseSpawner spawner = spawnerEntity.getSpawner();
                Entity toSpawn = spawner.getOrCreateDisplayEntity((Level)level, blockPos);
                if (toSpawn == null) {
                    return;
                }
                int i = 0;
                while ((float)i < v) {
                    EntityType type = toSpawn.getType();
                    if ((toSpawn = type.create((Level)level)) != null) {
                        double range = 4.0;
                        double sx = (double)blockPos.getX() + (random.nextDouble() - random.nextDouble()) * range + 0.5;
                        double sy = blockPos.getY() + random.nextInt(3) - 1;
                        double sz = (double)blockPos.getZ() + (random.nextDouble() - random.nextDouble()) * range + 0.5;
                        toSpawn.moveTo(sx, sy, sz, random.nextFloat() * 360.0f, 0.0f);
                        level.addFreshEntity(toSpawn);
                        if (toSpawn instanceof Mob) {
                            Mob mob = (Mob)toSpawn;
                            mob.spawnAnim();
                        }
                    }
                    ++i;
                }
            }
        });
        this.createEffect(level, (MalumNetworkedParticleEffectType)MalumParticleEffectTypes.BLOCK_RITE_EFFECT, activator.blockPosition(), List.of(MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT));
    }
}

