/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class GazeLesserAerialCorruptRiteEffect
extends SpiritRiteEntityEffect<LivingEntity> {
    public GazeLesserAerialCorruptRiteEffect() {
        super(new SpiritRiteEffectTag[]{SpiritRiteEffectTag.RADIAL_EFFECT});
    }

    public Class<LivingEntity> getTargetClass() {
        return LivingEntity.class;
    }

    public List<LivingEntity> findNearbyTargets(ServerLevel level, BlockPos source) {
        List targets = super.findNearbyTargets(level, source);
        Vec3 sourceVec = Vec3.atCenterOf((Vec3i)source);
        for (LivingEntity entity : targets) {
            Vec3 direction = sourceVec.subtract(entity.position()).normalize().scale(0.5);
            entity.setDeltaMovement(entity.getDeltaMovement().subtract(direction));
            entity.hurtMarked = true;
        }
        return targets;
    }

    public void applyEffect(ServerLevel level, LivingEntity entity) {
        this.createEffect(level, entity, new SpiritLike[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT});
    }
}

