/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.effect;

import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GazeLesserSacredCorruptedRiteEffect
extends SpiritRiteEntityEffect<Villager> {
    public GazeLesserSacredCorruptedRiteEffect() {
        super(List.of(SpiritRiteEffectTag.RADIAL_EFFECT));
    }

    public Class<Villager> getTargetClass() {
        return Villager.class;
    }

    public boolean canApplyEffect(ServerLevel level, Villager target) {
        return target.isAlive();
    }

    public void applyEffect(ServerLevel level, Villager target) {
        Vec3 pos = target.position();
        ZombieVillager zombie = (ZombieVillager)EntityType.ZOMBIE_VILLAGER.create((Level)level);
        if (zombie != null) {
            zombie.moveTo(pos.x, pos.y, pos.z, target.getYRot(), target.getXRot());
            zombie.setVillagerData(target.getVillagerData());
            target.discard();
            level.addFreshEntity((Entity)zombie);
            this.createEffect(level, (LivingEntity)target, List.of(MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT));
        }
    }
}

