/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.registry;

import com.sammy.malum.client.renderer.entity.bolt.HexBoltEntityRenderer;
import com.strawberry.gaze.client.renderer.entity.SaberEntityRenderer;
import com.strawberry.gaze.client.renderer.entity.SplinteredWorldEntityRenderer;
import com.strawberry.gaze.client.renderer.entity.SwordDomainEntityRenderer;
import com.strawberry.gaze.client.renderer.entity.VeilsEdgeEntityRenderer;
import com.strawberry.gaze.common.entity.SaberProjectileEntity;
import com.strawberry.gaze.common.entity.SeidhrBoltEntity;
import com.strawberry.gaze.common.entity.SplinteredWorldProjectileEntity;
import com.strawberry.gaze.common.entity.SwordDomainProjectileEntity;
import com.strawberry.gaze.common.entity.VeilDaggerProjectileEntity;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class GazeEntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"gaze");
    public static final DeferredHolder<EntityType<?>, EntityType<Entity>> SEIDHR_BOLT = ENTITY_TYPES.register("seidhr_bolt", () -> EntityType.Builder.of((e, w) -> new SeidhrBoltEntity(w), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build("gaze:seidhr_bolt"));
    public static final DeferredHolder<EntityType<?>, EntityType<Entity>> SABER = ENTITY_TYPES.register("saber", () -> EntityType.Builder.of((e, w) -> new SaberProjectileEntity(w), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build("gaze:saber"));
    public static final DeferredHolder<EntityType<?>, EntityType<Entity>> SWORD_DOMAIN_PROJECTILE = ENTITY_TYPES.register("sword_domain_projectile", () -> EntityType.Builder.of((e, w) -> new SwordDomainProjectileEntity(w), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build("gaze:sword_domain_projectile"));
    public static final DeferredHolder<EntityType<?>, EntityType<Entity>> VEILS_EDGE = ENTITY_TYPES.register("veils_edge", () -> EntityType.Builder.of((e, w) -> new VeilDaggerProjectileEntity(w), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build("gaze:veil_edge"));
    public static final DeferredHolder<EntityType<?>, EntityType<Entity>> SPLINTERED_WORLD = ENTITY_TYPES.register("splintered_world", () -> EntityType.Builder.of((e, w) -> new SplinteredWorldProjectileEntity(w), (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).build("gaze:splintered_world"));

    @EventBusSubscriber(modid="gaze", value={Dist.CLIENT})
    public static class ClientOnly {
        @SubscribeEvent
        public static void bindEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            EntityRenderers.register((EntityType)((EntityType)SEIDHR_BOLT.get()), HexBoltEntityRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)SABER.get()), SaberEntityRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)SWORD_DOMAIN_PROJECTILE.get()), SwordDomainEntityRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)VEILS_EDGE.get()), VeilsEdgeEntityRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)SPLINTERED_WORLD.get()), SplinteredWorldEntityRenderer::new);
        }
    }
}

