/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DefaultedEntityGeoModel<T extends GeoAnimatable>
extends DefaultedGeoModel<T> {
    @Nullable
    protected String headBone;
    @Deprecated(forRemoval=true)
    protected boolean turnsHead;

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath) {
        this(assetSubpath, false);
    }

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath, boolean turnsHead) {
        this(assetSubpath, turnsHead ? "head" : null);
    }

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath, @Nullable String headBone) {
        super(assetSubpath);
        this.turnsHead = headBone != null;
        this.headBone = headBone;
    }

    @Override
    protected String subtype() {
        return "entity";
    }

    @Override
    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        if (this.headBone == null || !this.turnsHead) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone(this.headBone);
        if (head != null) {
            EntityModelData entityData = animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltModel(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltModel(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltAnimations(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltAnimations(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltTexture(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltTexture(altPath);
    }
}

