/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.intervals;

import guideme.internal.shaded.lucene.queries.intervals.ConjunctionIntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.Disjunctions;
import guideme.internal.shaded.lucene.queries.intervals.IntervalIterator;
import guideme.internal.shaded.lucene.queries.intervals.IntervalsSource;
import guideme.internal.shaded.lucene.queries.intervals.MinimizingConjunctionIntervalsSource;
import guideme.internal.shaded.lucene.queries.intervals.RepeatingIntervalsSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class OrderedIntervalsSource
extends MinimizingConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        List<IntervalsSource> rewritten = OrderedIntervalsSource.deduplicate(sources);
        if (rewritten.size() == 1) {
            return rewritten.get(0);
        }
        return new OrderedIntervalsSource(rewritten);
    }

    private static List<IntervalsSource> deduplicate(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> deduplicated = new ArrayList<IntervalsSource>();
        ArrayList<IntervalsSource> current = new ArrayList<IntervalsSource>();
        for (IntervalsSource source : sources) {
            if (current.size() == 0 || ((IntervalsSource)current.get(0)).equals(source)) {
                current.add(source);
                continue;
            }
            deduplicated.add(RepeatingIntervalsSource.build((IntervalsSource)current.get(0), current.size()));
            current.clear();
            current.add(source);
        }
        deduplicated.add(RepeatingIntervalsSource.build((IntervalsSource)current.get(0), current.size()));
        if (deduplicated.size() == 1 && deduplicated.get(0) instanceof RepeatingIntervalsSource) {
            ((RepeatingIntervalsSource)deduplicated.get(0)).setName("ORDERED");
        }
        return deduplicated;
    }

    private OrderedIntervalsSource(List<IntervalsSource> sources) {
        super(sources);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
        return new OrderedIntervalIterator(iterators, onMatch);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, OrderedIntervalsSource::new);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrderedIntervalsSource)) {
            return false;
        }
        OrderedIntervalsSource s = (OrderedIntervalsSource)other;
        return Objects.equals(this.subSources, s.subSources);
    }

    @Override
    public String toString() {
        return "ORDERED(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class OrderedIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;
        int i = 1;
        int slop;
        final MinimizingConjunctionIntervalsSource.MatchCallback onMatch;

        private OrderedIntervalIterator(List<IntervalIterator> subIntervals, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
            super(subIntervals);
            this.onMatch = onMatch;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int nextInterval() throws IOException {
            this.slop = Integer.MAX_VALUE;
            this.end = Integer.MAX_VALUE;
            this.start = Integer.MAX_VALUE;
            int lastStart = Integer.MAX_VALUE;
            boolean minimizing = false;
            List subIterators = this.subIterators;
            int currentIndex = this.i;
            while (true) {
                int end;
                int start;
                int prevEnd = ((IntervalIterator)subIterators.get(currentIndex - 1)).end();
                while (true) {
                    int currentStart;
                    if (prevEnd >= lastStart) {
                        this.i = currentIndex;
                        return this.start;
                    }
                    if (currentIndex == subIterators.size()) break;
                    IntervalIterator current = (IntervalIterator)subIterators.get(currentIndex);
                    if (minimizing && current.start() > prevEnd) break;
                    do {
                        if (current.end() < lastStart && (currentStart = current.nextInterval()) != Integer.MAX_VALUE) continue;
                        this.i = currentIndex;
                        return this.start;
                    } while (currentStart <= prevEnd);
                    ++currentIndex;
                    prevEnd = current.end();
                }
                IntervalIterator first = (IntervalIterator)subIterators.get(0);
                this.start = start = first.start();
                if (start == Integer.MAX_VALUE) {
                    this.i = currentIndex;
                    this.end = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                IntervalIterator last = (IntervalIterator)subIterators.getLast();
                this.end = end = last.end();
                int slop = end - start + 1;
                int n = subIterators.size();
                for (int j = 0; j < n; ++j) {
                    slop -= ((IntervalIterator)subIterators.get(j)).width();
                }
                this.slop = slop;
                this.onMatch.onMatch();
                currentIndex = 1;
                if (first.nextInterval() == Integer.MAX_VALUE) {
                    this.i = currentIndex;
                    return start;
                }
                lastStart = last.start();
                minimizing = true;
            }
        }

        @Override
        public int gaps() {
            return this.slop;
        }

        @Override
        protected void reset() throws IOException {
            ((IntervalIterator)this.subIterators.get(0)).nextInterval();
            this.i = 1;
            this.slop = -1;
            this.end = -1;
            this.start = -1;
        }
    }
}

