/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.payloads;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.queries.payloads.PayloadMatcher;
import guideme.internal.shaded.lucene.queries.payloads.PayloadMatcherFactory;
import guideme.internal.shaded.lucene.queries.spans.FilterSpans;
import guideme.internal.shaded.lucene.queries.spans.SpanCollector;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanScorer;
import guideme.internal.shaded.lucene.queries.spans.SpanWeight;
import guideme.internal.shaded.lucene.queries.spans.Spans;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpanPayloadCheckQuery
extends SpanQuery {
    protected final List<BytesRef> payloadToMatch;
    protected final SpanQuery match;
    protected final MatchOperation operation;
    protected final PayloadType payloadType;

    public SpanPayloadCheckQuery(SpanQuery match, List<BytesRef> payloadToMatch) {
        this(match, payloadToMatch, PayloadType.STRING, MatchOperation.EQ);
    }

    public SpanPayloadCheckQuery(SpanQuery match, List<BytesRef> payloadToMatch, PayloadType payloadType, MatchOperation operation) {
        this.match = match;
        this.payloadToMatch = payloadToMatch;
        this.payloadType = payloadType;
        this.operation = operation;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, scoreMode, boost);
        return new SpanPayloadCheckWeight(searcher, scoreMode.needsScores() ? SpanPayloadCheckQuery.getTermStates(matchWeight) : null, matchWeight, boost, this.payloadType);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query matchRewritten = this.match.rewrite(indexSearcher);
        if (this.match != matchRewritten && matchRewritten instanceof SpanQuery) {
            return new SpanPayloadCheckQuery((SpanQuery)matchRewritten, this.payloadToMatch, this.payloadType, this.operation);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.match.getField())) {
            this.match.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SpanPayloadCheckQuery(");
        buffer.append(this.match.toString(field));
        buffer.append(", payloadRef: ");
        for (BytesRef bytes : this.payloadToMatch) {
            buffer.append(Term.toString(bytes));
            buffer.append(';');
        }
        buffer.append(", payloadType:").append((Object)this.payloadType).append(";");
        buffer.append(", operation:").append((Object)this.operation).append(";");
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.payloadToMatch.equals(((SpanPayloadCheckQuery)other).payloadToMatch) && this.match.equals(((SpanPayloadCheckQuery)other).match) && this.operation.equals((Object)((SpanPayloadCheckQuery)other).operation) && this.payloadType.equals((Object)((SpanPayloadCheckQuery)other).payloadType);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.match);
        result = 31 * result + Objects.hashCode(this.payloadToMatch);
        result = 31 * result + Objects.hashCode((Object)this.operation);
        result = 31 * result + Objects.hashCode((Object)this.payloadType);
        return result;
    }

    public static enum PayloadType {
        INT,
        FLOAT,
        STRING;

    }

    public static enum MatchOperation {
        EQ,
        GT,
        GTE,
        LT,
        LTE;

    }

    public class SpanPayloadCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPayloadCheckWeight(IndexSearcher searcher, Map<Term, TermStates> termStates, SpanWeight matchWeight, float boost, PayloadType payloadType) throws IOException {
            super(SpanPayloadCheckQuery.this, searcher, termStates, boost);
            this.matchWeight = matchWeight;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            this.matchWeight.extractTermStates(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            final PayloadChecker collector = new PayloadChecker();
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
            return matchSpans == null ? null : new FilterSpans(this, matchSpans){

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    collector.reset();
                    candidate.collect(collector);
                    return collector.match();
                }
            };
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            if (this.field == null) {
                return null;
            }
            Terms terms = context.reader().terms(this.field);
            if (terms != null && !terms.hasPositions()) {
                throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run SpanQuery (query=" + String.valueOf(this.parentQuery) + ")");
            }
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            NumericDocValues norms = context.reader().getNormValues(this.field);
            SpanScorer scorer = new SpanScorer(spans, this.getSimScorer(), norms);
            return new Weight.DefaultScorerSupplier(scorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.matchWeight.isCacheable(ctx);
        }
    }

    private class PayloadChecker
    implements SpanCollector {
        private int upto = 0;
        private boolean matches = true;
        private final PayloadMatcher payloadMatcher;

        private PayloadChecker() {
            this.payloadMatcher = PayloadMatcherFactory.createMatcherForOpAndType(SpanPayloadCheckQuery.this.payloadType, SpanPayloadCheckQuery.this.operation);
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            if (!this.matches) {
                return;
            }
            if (this.upto >= SpanPayloadCheckQuery.this.payloadToMatch.size()) {
                this.matches = false;
                return;
            }
            BytesRef payload = postings.getPayload();
            if (SpanPayloadCheckQuery.this.payloadToMatch.get(this.upto) == null) {
                this.matches = payload == null;
                ++this.upto;
                return;
            }
            if (payload == null) {
                this.matches = false;
                ++this.upto;
                return;
            }
            this.matches = this.payloadMatcher.comparePayload(SpanPayloadCheckQuery.this.payloadToMatch.get(this.upto), payload);
            ++this.upto;
        }

        FilterSpans.AcceptStatus match() {
            return this.matches && this.upto == SpanPayloadCheckQuery.this.payloadToMatch.size() ? FilterSpans.AcceptStatus.YES : FilterSpans.AcceptStatus.NO;
        }

        @Override
        public void reset() {
            this.upto = 0;
            this.matches = true;
        }
    }
}

