/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.ibicf;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.slf4j.Logger;

public record IBICFConfig(float cloudLevel, boolean renderClouds) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Codec<IBICFConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("cloudLevel").forGetter(IBICFConfig::cloudLevel), (App)Codec.BOOL.fieldOf("renderClouds").orElse((Object)true).forGetter(IBICFConfig::renderClouds)).apply((Applicative)instance, IBICFConfig::new));
    public static Supplier<IBICFConfig> CONFIG = Suppliers.memoize(() -> IBICFConfig.getOrCreateCodecConfig("ibicf", CODEC, () -> new IBICFConfig(128.0f, true)));

    public static <T> T getOrCreateCodecConfig(String name, Codec<T> codec, Supplier<T> defaultValue) {
        Path configPath = Services.PLATFORM.getConfigPath();
        Path config = configPath.resolve(name + ".json");
        if (!Files.exists(config, new LinkOption[0])) {
            T defaultConfig = defaultValue.get();
            IBICFConfig.save(codec, defaultConfig, config);
            return defaultConfig;
        }
        try {
            String jsonString = Files.readString(config);
            JsonElement parse = new JsonParser().parse(jsonString);
            DataResult data = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)parse);
            Object orThrow = data.getOrThrow();
            IBICFConfig.save(codec, orThrow, config);
            return (T)orThrow;
        }
        catch (Exception e) {
            LOGGER.error("Error loading config. Defaulting to default config", (Throwable)e);
            return defaultValue.get();
        }
    }

    private static <T> void save(Codec<T> codec, T config, Path path) {
        try {
            DataResult result = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, config);
            if (result.result().isPresent()) {
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.writeString(path, (CharSequence)GSON.toJson((JsonElement)result.result().get()), new OpenOption[0]);
            } else {
                LOGGER.error("Failed to load config: {}", result.error().get());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error saving config. Defaulting to default config", (Throwable)e);
        }
    }
}

