/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.proxy.block.filter.IFilter;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class RegulatorFilter<TYPE, CAP> {
    private final int sizeX;
    private final int sizeY;
    private final int locX;
    private final int locY;
    private final int smallMultiplier;
    private final int bigMultiplier;
    private final int maxAmount;
    private final String label;
    private final IFilter.GhostSlot[] filter;
    private boolean whitelisted = false;
    private boolean isRegulated = false;

    public RegulatorFilter(int locX, int locY, int sizeX, int sizeY, int smallMultiplier, int bigMultiplier, int maxAmount, String label) {
        this.locX = locX;
        this.locY = locY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.smallMultiplier = smallMultiplier;
        this.bigMultiplier = bigMultiplier;
        this.maxAmount = maxAmount;
        this.label = label;
        this.filter = new IFilter.GhostSlot[sizeX * sizeY];
        int pos = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                this.filter[pos] = new IFilter.GhostSlot(pos, locX + x * 18, locY + y * 18);
                this.filter[pos].setMaxAmount(this.maxAmount);
                ++pos;
            }
        }
    }

    public abstract boolean matches(TYPE var1, CAP var2);

    public abstract int getExtractAmount(TYPE var1, CAP var2);

    public abstract int getInsertAmount(TYPE var1, CAP var2);

    public abstract int getFilterAmount(TYPE var1);

    public abstract int getStorageAmount(TYPE var1, CAP var2);

    public boolean canExtract(TYPE stack, CAP cap) {
        return this.getExtractAmount(stack, cap) > 0;
    }

    public boolean canInsert(TYPE stack, CAP cap) {
        return this.getInsertAmount(stack, cap) > 0;
    }

    public boolean isRegulated() {
        return this.isRegulated;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public void setWhitelisted(boolean whitelisted) {
        this.whitelisted = whitelisted;
    }

    public void setRegulated(boolean regulated) {
        this.isRegulated = regulated;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getLocX() {
        return this.locX;
    }

    public int getLocY() {
        return this.locY;
    }

    public IFilter.GhostSlot[] getFilterSlots() {
        return this.filter;
    }

    public void setFilter(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getFilterSlots().length) {
            this.getFilterSlots()[slot].setStack(stack);
            this.getFilterSlots()[slot].setAmount(stack.getCount());
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Whitelist", this.whitelisted);
        compound.putBoolean("Regulated", this.isRegulated);
        for (int i = 0; i < this.getFilterSlots().length; ++i) {
            if (this.getFilterSlots()[i].getStack().isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.put("Stack", this.getFilterSlots()[i].getStack().saveOptional(provider));
            slot.putInt("Amount", this.getFilterSlots()[i].getAmount());
            compound.put(String.valueOf(i), (Tag)slot);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.whitelisted = nbt.getBoolean("Whitelist");
        this.isRegulated = nbt.getBoolean("Regulated");
        for (int i = 0; i < this.getFilterSlots().length; ++i) {
            if (nbt.contains(String.valueOf(i))) {
                CompoundTag slot = nbt.getCompound(String.valueOf(i));
                this.getFilterSlots()[i].setStack(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slot.getCompound("Stack")));
                this.getFilterSlots()[i].setAmount(slot.getInt("Amount"));
                continue;
            }
            this.getFilterSlots()[i].setStack(ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        for (IFilter.GhostSlot slot : this.getFilterSlots()) {
            if (slot.getStack().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getSmallMultiplier() {
        return this.smallMultiplier;
    }

    public int getBigMultiplier() {
        return this.bigMultiplier;
    }

    public String getLabel() {
        return this.label;
    }
}

