/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.IronsJewelry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public record PartDefinition(String descriptionId, ResourceLocation paletteKey, List<String> allowedMaterials, ResourceLocation baseTextureLocation) {
    public static final Codec<PartDefinition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("descriptionId").forGetter(PartDefinition::descriptionId), (App)ResourceLocation.CODEC.fieldOf("paletteKey").forGetter(PartDefinition::paletteKey), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("allowedMaterialTypes", List.of()).forGetter(PartDefinition::allowedMaterials), (App)ResourceLocation.CODEC.fieldOf("baseTextureLocation").forGetter(PartDefinition::baseTextureLocation)).apply((Applicative)builder, PartDefinition::new));

    public boolean canUseMaterial(String materialType) {
        return this.allowedMaterials.isEmpty() || this.allowedMaterials.contains(materialType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseMaterial(List<String> materialTypes) {
        if (this.allowedMaterials.isEmpty()) return true;
        if (!materialTypes.stream().anyMatch(this.allowedMaterials::contains)) return false;
        return true;
    }

    public static PartDefinition simpleMetalPart(String namespace, String name) {
        return new PartDefinition(String.format("part.%s.%s", namespace, name), IronsJewelry.id("palettes/gold"), List.of("metal"), ResourceLocation.fromNamespaceAndPath((String)namespace, (String)String.format("item/base/%s", name)));
    }

    public static PartDefinition simpleGemPart(String namespace, String name) {
        return new PartDefinition(String.format("part.%s.%s", namespace, name), IronsJewelry.id("palettes/diamond"), List.of("gem"), ResourceLocation.fromNamespaceAndPath((String)namespace, (String)String.format("item/base/%s", name)));
    }
}

