/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect;

import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class SpiderAspectEffect
extends MagicMobEffect {
    public static final float DAMAGE_PER_LEVEL = 0.05f;

    public SpiderAspectEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    @SubscribeEvent
    public static void increaseDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingAttacker;
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(MobEffectRegistry.SPIDER_ASPECT) && event.getEntity().hasEffect(MobEffects.POISON)) {
            int lvl = livingAttacker.getEffect(MobEffectRegistry.SPIDER_ASPECT).getAmplifier() + 1;
            float before = event.getAmount();
            float multiplier = 1.0f + 0.05f * (float)lvl;
            event.setAmount(event.getAmount() * multiplier);
        }
    }
}

