/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.BiomeRadarBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J:\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u001e\u0018\u00010\u001d\"\n\b\u0000\u0010\u001e*\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 H\u0016J \u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010$\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0014\u00a8\u0006)"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/BiomeRadarBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "clickedStack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "onRemove", "", "newState", "movedByPiston", "", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getShadeBrightness", "", "Lnet/minecraft/world/level/BlockGetter;", "propagatesSkylightDown", "getVisualShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "irregular-implements-1.21.1"})
public final class BiomeRadarBlock
extends Block
implements EntityBlock {
    public BiomeRadarBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.IRON_BLOCK)).noOcclusion().isViewBlocking(Blocks::never).isSuffocating(Blocks::never));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack clickedStack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)clickedStack, (String)"clickedStack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BiomeRadarBlockEntity biomeRadarBlockEntity = blockEntity instanceof BiomeRadarBlockEntity ? (BiomeRadarBlockEntity)blockEntity : null;
        if (biomeRadarBlockEntity == null) {
            return ItemInteractionResult.FAIL;
        }
        BiomeRadarBlockEntity blockEntity2 = biomeRadarBlockEntity;
        if (clickedStack.is((Holder)ModItems.INSTANCE.getLOCATION_FILTER())) {
            BlockPos blockPos = blockEntity2.getBiomePos();
            if (blockPos == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            BlockPos biomePos = blockPos;
            clickedStack.set((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS(), (Object)new GlobalPos(level.dimension(), biomePos));
            level.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS);
            AaronExtensions.INSTANCE.status(player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.biome_radar.filter_set", new Object[0]));
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack storedStack = blockEntity2.getBiomeStack();
        if (!storedStack.isEmpty()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)storedStack.copy(), (int)player.getInventory().selected);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            blockEntity2.setBiomeStack(itemStack);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        if (!clickedStack.has((Supplier)ModDataComponents.INSTANCE.getBIOME())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack itemStack = clickedStack.copyWithCount(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        blockEntity2.setBiomeStack(itemStack);
        clickedStack.shrink(1);
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS);
        return ItemInteractionResult.SUCCESS;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock()) && (be = level.getBlockEntity(pos)) instanceof BiomeRadarBlockEntity) {
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)((BiomeRadarBlockEntity)be).getBiomeStack());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new BiomeRadarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        BiomeRadarBlockEntity.Companion companion = BiomeRadarBlockEntity.Companion;
        return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getBIOME_RADAR().get()), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ BiomeRadarBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, BiomeRadarBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    protected float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 1.0f;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @NotNull
    protected VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        return voxelShape;
    }
}

