/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.FlooBrickBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooFireplace;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/FlooBrickBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "onRemove", "", "oldState", "level", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "irregular-implements-1.21.1"})
public final class FlooBrickBlock
extends Block
implements EntityBlock {
    public FlooBrickBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.BRICKS)).strength(2.0f, 10.0f));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new FlooBrickBlockEntity(pos, state);
    }

    protected void onRemove(@NotNull BlockState oldState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!oldState.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FlooBrickBlockEntity) {
            ((FlooBrickBlockEntity)blockEntity).blockBroken();
        }
        super.onRemove(oldState, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        MutableComponent mutableComponent;
        UUID uuid;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = ((ServerLevel)level).getBlockEntity(pos);
        FlooBrickBlockEntity flooBrickBlockEntity = blockEntity instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)blockEntity : null;
        if (flooBrickBlockEntity == null) {
            return InteractionResult.PASS;
        }
        FlooBrickBlockEntity blockEntity2 = flooBrickBlockEntity;
        UUID uUID = blockEntity2.getUuid();
        if (uUID == null) {
            uUID = blockEntity2.getMasterUUID();
        }
        if ((uuid = uUID) == null) {
            AaronExtensions.INSTANCE.status(player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.no_name", new Object[0]));
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get((ServerLevel)level);
        FlooFireplace fireplace = network.findFireplace(uuid);
        if (fireplace == null) {
            AaronExtensions.INSTANCE.status(player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.broken", new Object[0]));
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        String name = fireplace.getName();
        if (name == null) {
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.no_name", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{name};
            mutableComponent = ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.name", objectArray);
        }
        MutableComponent component = mutableComponent;
        AaronExtensions.INSTANCE.status(player, (Component)component);
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }
}

