/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.IronDropperBlockEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.VanillaInventoryCodeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J:\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000b\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/IronDropperBlock;", "Lnet/minecraft/world/level/block/DropperBlock;", "<init>", "()V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "level", "Lnet/minecraft/world/level/Level;", "state", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "dispenseFrom", "", "Lnet/minecraft/server/level/ServerLevel;", "pos", "irregular-implements-1.21.1"})
public final class IronDropperBlock
extends DropperBlock {
    public IronDropperBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.DROPPER)));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return (BlockEntity)new IronDropperBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        IronDropperBlockEntity.Companion companion = IronDropperBlockEntity.Companion;
        return DropperBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getIRON_DROPPER().get()), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ IronDropperBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, IronDropperBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    public void dispenseFrom(@NotNull ServerLevel level, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        IronDropperBlockEntity ironDropperBlockEntity = blockEntity instanceof IronDropperBlockEntity ? (IronDropperBlockEntity)blockEntity : null;
        if (ironDropperBlockEntity == null) {
            return;
        }
        IronDropperBlockEntity blockEntity2 = ironDropperBlockEntity;
        BlockSource blockSource = new BlockSource(level, pos, state, (DispenserBlockEntity)blockEntity2);
        int slot = blockEntity2.getRandomSlot(level.random);
        if (slot < 0) {
            if (blockEntity2.getEffectsMode().getHasSound()) {
                level.levelEvent(1001, pos, 0);
            }
            return;
        }
        ItemStack stack = blockEntity2.getItem(slot);
        if (stack.isEmpty() || !VanillaInventoryCodeHooks.dropperInsertHook((Level)((Level)level), (BlockPos)pos, (DispenserBlockEntity)blockEntity2, (int)slot, (ItemStack)stack)) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)DropperBlock.FACING);
        Container container2 = HopperBlockEntity.getContainerAt((Level)((Level)level), (BlockPos)pos.relative(direction));
        if (container2 == null) {
            ItemStack remainder = blockEntity2.getDispenseBehavior().dispense(blockSource, stack);
            blockEntity2.setItem(slot, remainder);
            return;
        }
        ItemStack stackToShoot = HopperBlockEntity.addItem((Container)((Container)blockEntity2), (Container)container2, (ItemStack)stack.copyWithCount(1), (Direction)direction.getOpposite());
        if (stackToShoot.isEmpty()) {
            stackToShoot = stack.copy();
            stackToShoot.shrink(1);
        } else {
            stackToShoot = stack.copy();
        }
        blockEntity2.setItem(slot, stackToShoot);
    }
}

