/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooFireplace;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.ServerChatEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isMaster", "", "value", "Ljava/util/UUID;", "uuid", "getUuid", "()Ljava/util/UUID;", "Lnet/minecraft/core/Direction;", "facing", "getFacing", "()Lnet/minecraft/core/Direction;", "", "children", "getChildren", "()Ljava/util/List;", "masterUUID", "getMasterUUID", "setupMaster", "", "setupChild", "blockBroken", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFlooBrickBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlooBrickBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n1563#2:162\n1634#2,3:163\n11601#3:166\n11936#3,3:167\n*S KotlinDebug\n*F\n+ 1 FlooBrickBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity\n*L\n89#1:162\n89#1:163,3\n108#1:166\n108#1:167,3\n*E\n"})
public final class FlooBrickBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isMaster;
    @Nullable
    private UUID uuid;
    @NotNull
    private Direction facing;
    @NotNull
    private List<? extends BlockPos> children;
    @Nullable
    private UUID masterUUID;
    @NotNull
    public static final String IS_MASTER_TAG = "IsMaster";
    @NotNull
    public static final String UUID_TAG = "UUID";
    @NotNull
    public static final String FACING_TAG = "Facing";
    @NotNull
    public static final String CHILDREN_TAG = "Children";
    @NotNull
    public static final String MASTER_UUID_TAG = "MasterUUID";

    public FlooBrickBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getFLOO_BRICK().get(), pos, blockState);
        this.facing = Direction.NORTH;
        this.children = CollectionsKt.emptyList();
    }

    @Nullable
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final Direction getFacing() {
        return this.facing;
    }

    @NotNull
    public final List<BlockPos> getChildren() {
        return this.children;
    }

    @Nullable
    public final UUID getMasterUUID() {
        return this.masterUUID;
    }

    public final void setupMaster(@NotNull UUID uuid, @NotNull Direction facing, @NotNull List<? extends BlockPos> children) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.isMaster = true;
        this.uuid = uuid;
        this.facing = facing;
        this.children = children;
        this.setChanged();
    }

    public final void setupChild(@NotNull UUID masterUUID) {
        Intrinsics.checkNotNullParameter((Object)masterUUID, (String)"masterUUID");
        this.isMaster = false;
        this.masterUUID = masterUUID;
        this.setChanged();
    }

    public final void blockBroken() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        if (this.isMaster) {
            for (BlockPos blockPos : this.children) {
                level2.setBlockAndUpdate(blockPos, Blocks.BRICKS.defaultBlockState());
            }
            level2.setBlockAndUpdate(this.worldPosition, Blocks.BRICKS.defaultBlockState());
            UUID uuid = this.uuid;
            if (uuid != null) {
                FlooNetworkSavedData flooNetworkSavedData = FlooNetworkSavedData.Companion.get(level2);
                flooNetworkSavedData.removeFireplace(uuid);
            }
        } else {
            UUID uUID = this.masterUUID;
            if (uUID == null) {
                return;
            }
            UUID master = uUID;
            FlooNetworkSavedData flooNetworkSavedData = FlooNetworkSavedData.Companion.get(level2);
            FlooFireplace flooFireplace = flooNetworkSavedData.findFireplace(master);
            if (flooFireplace == null) {
                return;
            }
            FlooFireplace fireplace = flooFireplace;
            BlockEntity blockEntity = level2.getBlockEntity(fireplace.getMasterBlockPos());
            FlooBrickBlockEntity flooBrickBlockEntity = blockEntity instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)blockEntity : null;
            if (flooBrickBlockEntity == null) {
                return;
            }
            FlooBrickBlockEntity be = flooBrickBlockEntity;
            be.blockBroken();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putBoolean(IS_MASTER_TAG, this.isMaster);
        if (this.isMaster) {
            void $this$mapTo$iv$iv;
            UUID uuid = this.uuid;
            if (uuid != null) {
                tag.putUUID(UUID_TAG, uuid);
            }
            tag.putInt(FACING_TAG, this.facing.ordinal());
            Iterable $this$map$iv = this.children;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.asLong());
            }
            List list = (List)destination$iv$iv;
            LongArrayTag childrenList = new LongArrayTag(list);
            tag.put(CHILDREN_TAG, (Tag)childrenList);
        } else {
            UUID master = this.masterUUID;
            if (master != null) {
                tag.putUUID(MASTER_UUID_TAG, master);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.isMaster = tag.getBoolean(IS_MASTER_TAG);
        if (this.isMaster) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            UUID uUID = AaronExtensions.INSTANCE.getUuidOrNull(tag, UUID_TAG);
            if (uUID == null) {
                uUID = UUID.randomUUID();
            }
            this.uuid = uUID;
            int directionOrdinal = tag.getInt(FACING_TAG);
            this.facing = (Direction)EntriesMappings.entries$0.get(directionOrdinal);
            long[] lArray = tag.getLongArray(CHILDREN_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"getLongArray(...)");
            long[] lArray2 = lArray;
            FlooBrickBlockEntity flooBrickBlockEntity = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void item$iv$iv;
                void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BlockPos.of((long)p0));
            }
            flooBrickBlockEntity.children = (List)destination$iv$iv;
        } else {
            this.masterUUID = AaronExtensions.INSTANCE.getUuidOrNull(tag, MASTER_UUID_TAG);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity$Companion;", "", "<init>", "()V", "IS_MASTER_TAG", "", "UUID_TAG", "FACING_TAG", "CHILDREN_TAG", "MASTER_UUID_TAG", "processMessage", "", "event", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nFlooBrickBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlooBrickBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n295#2,2:162\n*S KotlinDebug\n*F\n+ 1 FlooBrickBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity$Companion\n*L\n130#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void processMessage(@NotNull ServerChatEvent event) {
            Object v1;
            Object element$iv2;
            boolean holdingPowder;
            String message;
            ServerLevel level;
            ServerPlayer player;
            block12: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCanceled()) {
                    return;
                }
                player = event.getPlayer();
                level = player.serverLevel();
                message = event.getMessage().getString();
                holdingPowder = player.isHolding((Item)ModItems.INSTANCE.getFLOO_POWDER().get());
                NonNullList nonNullList = player.getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                Iterable $this$firstOrNull$iv = (Iterable)nonNullList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    ItemStack it = (ItemStack)element$iv2;
                    boolean bl = false;
                    if (!it.is((Holder)ModItems.INSTANCE.getFLOO_POUCH())) continue;
                    v1 = element$iv2;
                    break block12;
                }
                v1 = null;
            }
            ItemStack pouch = v1;
            if (!player.hasInfiniteMaterials() && !holdingPowder) {
                int amount;
                Object object = pouch;
                int n = object != null && (object = (Integer)object.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0)) != null ? (Integer)object : (amount = 0);
                if (amount <= 0) {
                    return;
                }
            }
            Optional optional = player.mainSupportingBlockPos;
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"mainSupportingBlockPos");
            BlockPos blockPos = (BlockPos)OptionalsKt.getOrNull((Optional)optional);
            if (blockPos == null) {
                return;
            }
            BlockPos pos = blockPos;
            element$iv2 = level.getBlockEntity(pos);
            FlooBrickBlockEntity flooBrickBlockEntity = element$iv2 instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)((Object)element$iv2) : null;
            if (flooBrickBlockEntity == null) {
                return;
            }
            FlooBrickBlockEntity brick = flooBrickBlockEntity;
            Intrinsics.checkNotNull((Object)level);
            FlooFireplace flooFireplace = FlooNetworkSavedData.Companion.get(level).findFireplace(brick);
            if (flooFireplace == null) {
                return;
            }
            FlooFireplace fireplace = flooFireplace;
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)message);
            if (!fireplace.teleportFromThis(player, message)) {
                return;
            }
            if (!player.hasInfiniteMaterials()) {
                if (holdingPowder) {
                    ItemStack stack = player.getMainHandItem().is((Item)ModItems.INSTANCE.getFLOO_POWDER().get()) ? player.getMainHandItem() : player.getOffhandItem();
                    stack.shrink(1);
                } else if (pouch != null) {
                    Integer current = (Integer)pouch.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)1);
                    pouch.set((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)(current - 1));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

