/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SpectreLensBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Ljava/util/UUID;", "owner", "getOwner", "()Ljava/util/UUID;", "setOwner", "(Ljava/util/UUID;)V", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Companion", "irregular-implements-1.21.1"})
public final class SpectreLensBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID owner;
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUuid";

    public SpectreLensBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getSPECTRE_LENS().get(), pPos, pBlockState);
    }

    @Nullable
    public final UUID getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable UUID value) {
        this.owner = value;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        if (this.owner != null) {
            UUID uUID = this.owner;
            Intrinsics.checkNotNull((Object)uUID);
            tag.putUUID(OWNER_UUID_NBT, uUID);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.setOwner(AaronExtensions.INSTANCE.getUuidOrNull(tag, OWNER_UUID_NBT));
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @JvmStatic
    public static final void applyEffects(@NotNull Level level, @NotNull BlockPos pos, int beaconLevel, @Nullable Holder<MobEffect> primaryEffect, @Nullable Holder<MobEffect> secondaryEffect) {
        Companion.applyEffects(level, pos, beaconLevel, primaryEffect, secondaryEffect);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SpectreLensBlockEntity$Companion;", "", "<init>", "()V", "OWNER_UUID_NBT", "", "applyEffects", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "beaconLevel", "", "primaryEffect", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/effect/MobEffect;", "secondaryEffect", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void applyEffects(@NotNull Level level, @NotNull BlockPos pos, int beaconLevel, @Nullable Holder<MobEffect> primaryEffect, @Nullable Holder<MobEffect> secondaryEffect) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            if (level.isClientSide || primaryEffect == null) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos.above());
            SpectreLensBlockEntity spectreLensBlockEntity = blockEntity instanceof SpectreLensBlockEntity ? (SpectreLensBlockEntity)blockEntity : null;
            if (spectreLensBlockEntity == null) {
                return;
            }
            SpectreLensBlockEntity blockEntity2 = spectreLensBlockEntity;
            UUID uUID = blockEntity2.getOwner();
            if (uUID == null) {
                return;
            }
            UUID owner = uUID;
            Player player = level.getPlayerByUUID(owner);
            if (player == null) {
                return;
            }
            Player player2 = player;
            boolean sameEffect = secondaryEffect != null && Intrinsics.areEqual(primaryEffect, secondaryEffect);
            int amplifier = beaconLevel >= 4 && sameEffect ? 1 : 0;
            int duration = (9 + beaconLevel * 2) * 20;
            MobEffectInstance primaryEffectInstance = new MobEffectInstance(primaryEffect, duration, amplifier, true, true);
            player2.addEffect(primaryEffectInstance);
            if (beaconLevel >= 4 && secondaryEffect != null && !sameEffect) {
                MobEffectInstance secondaryEffectInstance = new MobEffectInstance(secondaryEffect, duration, 0, true, true);
                player2.addEffect(secondaryEffectInstance);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

