/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render;

import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.irregular_implements.client.render.CubeIndicatorRenderer;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.item.DiviningRodItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/DiviningRodRenderer;", "", "<init>", "()V", "addCubeIndicators", "", "event", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "irregular-implements-1.21.1"})
public final class DiviningRodRenderer {
    @NotNull
    public static final DiviningRodRenderer INSTANCE = new DiviningRodRenderer();

    private DiviningRodRenderer() {
    }

    public final void addCubeIndicators(@NotNull ClientTickEvent.Post event) {
        TagKey mainHandTag;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = AaronClientUtil.getLocalPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        BlockPos playerPos = player2.blockPosition();
        Level level = player2.level();
        ItemStack offHandItem = player2.getOffhandItem();
        ItemStack mainHandItem = player2.getMainHandItem();
        TagKey offHandTag = offHandItem.is((Holder)ModItems.INSTANCE.getDIVINING_ROD()) ? (TagKey)offHandItem.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_TAG()) : null;
        TagKey tagKey = mainHandTag = mainHandItem.is((Holder)ModItems.INSTANCE.getDIVINING_ROD()) ? (TagKey)mainHandItem.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_TAG()) : null;
        if (offHandTag == null && mainHandTag == null) {
            return;
        }
        Integer radius = (Integer)ServerConfig.Companion.getCONFIG().getDiviningRodCheckRadius().get();
        BlockPos blockPos = playerPos.offset(-radius.intValue(), -radius.intValue(), -radius.intValue());
        Intrinsics.checkNotNull((Object)radius);
        Stream positions = BlockPos.betweenClosedStream((BlockPos)blockPos, (BlockPos)playerPos.offset(radius.intValue(), radius.intValue(), radius.intValue()));
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            boolean matchesMainHand;
            BlockPos checkedPos = (BlockPos)iterator.next();
            if (!level.isLoaded(checkedPos)) continue;
            BlockState checkedState = level.getBlockState(checkedPos);
            boolean matchesOffHand = offHandTag != null && checkedState.is(offHandTag);
            boolean bl = matchesMainHand = mainHandTag != null && checkedState.is(mainHandTag);
            if (!matchesOffHand && !matchesMainHand) continue;
            BlockPos blockPos2 = checkedPos.immutable();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"immutable(...)");
            Intrinsics.checkNotNull((Object)checkedState);
            CubeIndicatorRenderer.addIndicator$default(CubeIndicatorRenderer.INSTANCE, blockPos2, 1, DiviningRodItem.Companion.getOverlayColor(checkedState), 0.0f, 8, null);
        }
    }
}

