/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooFireplace;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModParticleTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.ServerChatEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/TemporaryFlooFireplaceEntity;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "pos", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "age", "", "tick", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "Companion", "irregular-implements-1.21.1"})
public final class TemporaryFlooFireplaceEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int age;

    public TemporaryFlooFireplaceEntity(@NotNull EntityType<?> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public TemporaryFlooFireplaceEntity(@NotNull Level level, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Object object = ModEntityTypes.INSTANCE.getTEMPORARY_FLOO_FIREPLACE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType)object, level);
        this.setPos(pos);
    }

    public void tick() {
        super.tick();
        int n = this.age;
        this.age = n + 1;
        Level level = this.level();
        if (AaronExtensions.INSTANCE.isClientSide((Entity)this) && this.age > 7) {
            for (int i = 0; i < 40; ++i) {
                double iProgress = (double)i / (double)40;
                double x = this.getX() - 1.0 + iProgress * (double)2;
                for (int j = 0; j < 40; ++j) {
                    double jProgress = (double)j / (double)40;
                    double z = this.getZ() - 1.0 + jProgress * (double)2;
                    level.addParticle((ParticleOptions)ModParticleTypes.INSTANCE.getFLOO_FLAME().get(), x, this.getY(), z, 0.0, level.random.nextDouble() * 0.1, 0.0);
                }
            }
        }
        if (!AaronExtensions.INSTANCE.isClientSide((Entity)this) && this.age >= 600) {
            this.discard();
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/TemporaryFlooFireplaceEntity$Companion;", "", "<init>", "()V", "processMessage", "", "event", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void processMessage(@NotNull ServerChatEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled()) {
                return;
            }
            ServerPlayer player = event.getPlayer();
            ServerLevel level = player.serverLevel();
            List list = level.getEntitiesOfClass(TemporaryFlooFireplaceEntity.class, player.getBoundingBox().inflate(0.5));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            TemporaryFlooFireplaceEntity tempFireplace = (TemporaryFlooFireplaceEntity)((Object)CollectionsKt.firstOrNull((List)list));
            if (tempFireplace == null) {
                return;
            }
            String message = event.getMessage().getString();
            Intrinsics.checkNotNull((Object)level);
            FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get(level);
            Intrinsics.checkNotNull((Object)message);
            FlooFireplace destination = network.findFireplace(message);
            if (destination == null) {
                Intrinsics.checkNotNull((Object)player);
                Object[] objectArray = new Object[]{message};
                AaronExtensions.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.not_found", objectArray));
                return;
            }
            tempFireplace.discard();
            Intrinsics.checkNotNull((Object)player);
            destination.teleportToThis(player);
            event.setCanceled(true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

