/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.ender_letter;

import dev.aaronhowser.mods.irregular_implements.handler.ender_letter.EnderLetterHandler;
import dev.aaronhowser.mods.irregular_implements.handler.ender_letter.EnderMailboxInventory;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderMailboxContainer;", "Lnet/minecraft/world/Container;", "player", "Lnet/minecraft/world/entity/player/Player;", "blockPos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "inventory", "Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderMailboxInventory;", "getInventory", "()Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderMailboxInventory;", "getContainerSize", "", "isEmpty", "", "getItem", "Lnet/minecraft/world/item/ItemStack;", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "", "stack", "setChanged", "stillValid", "clearContent", "irregular-implements-1.21.1"})
public final class EnderMailboxContainer
implements Container {
    @NotNull
    private final Player player;
    @NotNull
    private final BlockPos blockPos;
    @Nullable
    private final EnderMailboxInventory inventory;

    public EnderMailboxContainer(@NotNull Player player, @NotNull BlockPos blockPos) {
        EnderMailboxInventory enderMailboxInventory;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.player = player;
        this.blockPos = blockPos;
        if (this.player instanceof ServerPlayer) {
            ServerLevel serverLevel = ((ServerPlayer)this.player).serverLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
            EnderLetterHandler enderLetterHandler = EnderLetterHandler.Companion.get(serverLevel);
            UUID uUID = ((ServerPlayer)this.player).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            enderMailboxInventory = enderLetterHandler.getOrCreateInventory(uUID);
        } else {
            enderMailboxInventory = null;
        }
        this.inventory = enderMailboxInventory;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Nullable
    public final EnderMailboxInventory getInventory() {
        return this.inventory;
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        EnderMailboxInventory enderMailboxInventory = this.inventory;
        return enderMailboxInventory != null ? !enderMailboxInventory.hasRoom() : false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        EnderMailboxInventory enderMailboxInventory = this.inventory;
        if (enderMailboxInventory == null || (enderMailboxInventory = enderMailboxInventory.getStackInSlot(slot)) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            enderMailboxInventory = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        }
        return enderMailboxInventory;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        EnderMailboxInventory enderMailboxInventory = this.inventory;
        if (enderMailboxInventory == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EnderMailboxInventory inv = enderMailboxInventory;
        if (!(0 <= slot ? slot < inv.getSlots() : false)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        return inv.extractItem(slot, amount, false);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        EnderMailboxInventory enderMailboxInventory = this.inventory;
        if (enderMailboxInventory == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        EnderMailboxInventory inv = enderMailboxInventory;
        if (!(0 <= slot ? slot < inv.getSlots() : false)) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack stack = inv.getStackInSlot(slot).copy();
        inv.getEnderLetters().set(slot, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNull((Object)stack);
        return stack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        EnderMailboxInventory enderMailboxInventory = this.inventory;
        if (enderMailboxInventory == null) {
            return;
        }
        EnderMailboxInventory inv = enderMailboxInventory;
        if (!(0 <= slot ? slot < inv.getSlots() : false)) {
            return;
        }
        inv.getEnderLetters().set(slot, (Object)stack.copy());
        this.setChanged();
    }

    public void setChanged() {
        block0: {
            Object object = this.inventory;
            if (object == null || (object = object.getEnderLetterHandler()) == null) break block0;
            object.setDirty();
        }
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.level().getBlockState(this.blockPos).is((Holder)ModBlocks.INSTANCE.getENDER_MAILBOX());
    }

    public void clearContent() {
        NonNullList<ItemStack> nonNullList = this.inventory;
        if (nonNullList != null && (nonNullList = nonNullList.getEnderLetters()) != null) {
            nonNullList.replaceAll(EnderMailboxContainer::clearContent$lambda$0);
        }
        this.setChanged();
    }

    private static final ItemStack clearContent$lambda$0(ItemStack it) {
        return ItemStack.EMPTY;
    }
}

