/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.entity.SpectreIlluminatorEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlackoutPowderItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "irregular-implements-1.21.1"})
public final class BlackoutPowderItem
extends Item {
    public BlackoutPowderItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        ChunkPos chunkPos = new ChunkPos(clickedPos);
        int minX = chunkPos.getMinBlockX();
        int minY = level.getMinBuildHeight();
        int minZ = chunkPos.getMinBlockZ();
        int maxX = chunkPos.getMaxBlockX();
        int maxY = level.getMaxBuildHeight() + 150;
        int maxZ = chunkPos.getMaxBlockZ();
        AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        List illuminators = level.getEntitiesOfClass(SpectreIlluminatorEntity.class, aabb);
        if (illuminators.isEmpty()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        for (SpectreIlluminatorEntity illuminator : illuminators) {
            illuminator.discard();
            Player player2 = player;
            if (AaronExtensions.INSTANCE.isTrue(player2 != null ? Boolean.valueOf(player2.hasInfiniteMaterials()) : null)) continue;
            ItemStack itemStack = ModItems.INSTANCE.getSPECTRE_ILLUMINATOR().toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
            Level level2 = illuminator.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            Vec3 vec3 = clickedPos.relative(context.getClickedFace()).getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            OtherUtil.dropStackAt$default(OtherUtil.INSTANCE, itemStack, level2, vec3, false, 8, null);
        }
        context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }
}

