/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModFluidTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020(J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0011\u0010!\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013\u00a8\u0006."}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/ModArmorItems;", "", "<init>", "()V", "registerArmorItem", "Lnet/neoforged/neoforge/registries/DeferredItem;", "Lnet/minecraft/world/item/ArmorItem;", "name", "", "material", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/ArmorMaterial;", "type", "Lnet/minecraft/world/item/ArmorItem$Type;", "properties", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item$Properties;", "MAGIC_HOOD_PROPERTIES", "getMAGIC_HOOD_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "WATER_WALKING_BOOTS_PROPERTIES", "getWATER_WALKING_BOOTS_PROPERTIES", "()Ljava/util/function/Supplier;", "OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES", "getOBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES", "LAVA_WADERS_PROPERTIES", "getLAVA_WADERS_PROPERTIES", "SPECTRE_HELMET_PROPERTIES", "getSPECTRE_HELMET_PROPERTIES", "SPECTRE_CHESTPLATE_PROPERTIES", "getSPECTRE_CHESTPLATE_PROPERTIES", "SPECTRE_LEGGINGS_PROPERTIES", "getSPECTRE_LEGGINGS_PROPERTIES", "SPECTRE_BOOTS_PROPERTIES", "getSPECTRE_BOOTS_PROPERTIES", "lubricatedTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "tryBlockFireDamage", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "canBlockFireDamage", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "isWearingFullSpectreArmor", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nModArmorItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModArmorItems.kt\ndev/aaronhowser/mods/irregular_implements/item/ModArmorItems\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1761#2,3:160\n1761#2,3:163\n*S KotlinDebug\n*F\n+ 1 ModArmorItems.kt\ndev/aaronhowser/mods/irregular_implements/item/ModArmorItems\n*L\n147#1:160,3\n149#1:163,3\n*E\n"})
public final class ModArmorItems {
    @NotNull
    public static final ModArmorItems INSTANCE = new ModArmorItems();
    @NotNull
    private static final Item.Properties MAGIC_HOOD_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> WATER_WALKING_BOOTS_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> LAVA_WADERS_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_HELMET_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_CHESTPLATE_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_LEGGINGS_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_BOOTS_PROPERTIES;

    private ModArmorItems() {
    }

    @NotNull
    public final DeferredItem<ArmorItem> registerArmorItem(@NotNull String name, @NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull Supplier<Item.Properties> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        DeferredItem deferredItem = ModItems.INSTANCE.getITEM_REGISTRY().registerItem(name, arg_0 -> ModArmorItems.registerArmorItem$lambda$0(material, type, properties, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferredItem, (String)"registerItem(...)");
        return deferredItem;
    }

    @NotNull
    public final DeferredItem<ArmorItem> registerArmorItem(@NotNull String name, @NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DeferredItem deferredItem = ModItems.INSTANCE.getITEM_REGISTRY().registerItem(name, arg_0 -> ModArmorItems.registerArmorItem$lambda$1(material, type, properties, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferredItem, (String)"registerItem(...)");
        return deferredItem;
    }

    @NotNull
    public final Item.Properties getMAGIC_HOOD_PROPERTIES() {
        return MAGIC_HOOD_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getWATER_WALKING_BOOTS_PROPERTIES() {
        return WATER_WALKING_BOOTS_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getOBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES() {
        return OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getLAVA_WADERS_PROPERTIES() {
        return LAVA_WADERS_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_HELMET_PROPERTIES() {
        return SPECTRE_HELMET_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_CHESTPLATE_PROPERTIES() {
        return SPECTRE_CHESTPLATE_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_LEGGINGS_PROPERTIES() {
        return SPECTRE_LEGGINGS_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_BOOTS_PROPERTIES() {
        return SPECTRE_BOOTS_PROPERTIES;
    }

    public final void lubricatedTooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getItemStack().has((Supplier)ModDataComponents.LUBRICATED)) {
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.lubricated", new Object[0]).withColor(16577757));
        }
    }

    public final void tryBlockFireDamage(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (!damageSource.is(DamageTypeTags.IS_FIRE)) {
            return;
        }
        float amount = event.getAmount();
        float chance = amount * amount * amount / (float)100;
        if (target.getRandom().nextFloat() <= chance) {
            return;
        }
        Intrinsics.checkNotNull((Object)target);
        if (this.canBlockFireDamage(target)) {
            event.setCanceled(true);
        }
    }

    private final boolean canBlockFireDamage(LivingEntity entity) {
        boolean bl;
        block11: {
            ItemStack it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            ItemStack footItem = entity.getItemBySlot(EquipmentSlot.FEET);
            if (footItem.is((Holder)ModItems.INSTANCE.getLAVA_WADERS()) || footItem.is((Holder)ModItems.INSTANCE.getOBSIDIAN_WATER_WALKING_BOOTS())) {
                return true;
            }
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getCuriosInventory(...)");
            ICuriosItemHandler iCuriosItemHandler = (ICuriosItemHandler)OptionalsKt.getOrNull((Optional)optional);
            boolean hasObsidianSkullRing = AaronExtensions.INSTANCE.isTrue(iCuriosItemHandler != null ? Boolean.valueOf(iCuriosItemHandler.isEquipped((Item)ModItems.INSTANCE.getOBSIDIAN_SKULL_RING().get())) : null);
            if (hasObsidianSkullRing) {
                return true;
            }
            if (entity instanceof Player) {
                boolean bl2;
                block10: {
                    NonNullList nonNullList = ((Player)entity).getInventory().items;
                    Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                    $this$any$iv = (Iterable)nonNullList;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ItemStack)element$iv;
                            boolean bl3 = false;
                            if (!it.is((Holder)ModItems.INSTANCE.getOBSIDIAN_SKULL())) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return true;
                }
            }
            Iterable iterable = entity.getHandSlots();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
            $this$any$iv = iterable;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ItemStack)element$iv;
                    boolean bl4 = false;
                    if (!it.is((Holder)ModItems.INSTANCE.getOBSIDIAN_SKULL())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isWearingFullSpectreArmor(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getItemBySlot(EquipmentSlot.HEAD).is((Item)ModItems.INSTANCE.getSPECTRE_HELMET().get()) && entity.getItemBySlot(EquipmentSlot.CHEST).is((Item)ModItems.INSTANCE.getSPECTRE_CHESTPLATE().get()) && entity.getItemBySlot(EquipmentSlot.LEGS).is((Item)ModItems.INSTANCE.getSPECTRE_LEGGINGS().get()) && entity.getItemBySlot(EquipmentSlot.FEET).is((Item)ModItems.INSTANCE.getSPECTRE_BOOTS().get());
    }

    private static final ArmorItem registerArmorItem$lambda$0(Holder $material, ArmorItem.Type $type, Supplier $properties, Item.Properties it) {
        return new ArmorItem($material, $type, (Item.Properties)$properties.get());
    }

    private static final ArmorItem registerArmorItem$lambda$1(Holder $material, ArmorItem.Type $type, Item.Properties $properties, Item.Properties it) {
        return new ArmorItem($material, $type, $properties);
    }

    private static final Item.Properties WATER_WALKING_BOOTS_PROPERTIES$lambda$2() {
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).component((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.listOf(ModFluidTagsProvider.ALLOWS_WATER_WALKING));
    }

    private static final Item.Properties OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES$lambda$3() {
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).fireResistant().component((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.listOf(ModFluidTagsProvider.ALLOWS_WATER_WALKING));
    }

    private static final Item.Properties LAVA_WADERS_PROPERTIES$lambda$4() {
        Object[] objectArray = new TagKey[]{ModFluidTagsProvider.ALLOWS_LAVA_WALKING, ModFluidTagsProvider.ALLOWS_WATER_WALKING};
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).fireResistant().component((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.listOf((Object[])objectArray)).component((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)200).component((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN(), (Object)0);
    }

    static {
        Item.Properties properties = new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(15)).rarity(Rarity.RARE);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"rarity(...)");
        MAGIC_HOOD_PROPERTIES = properties;
        WATER_WALKING_BOOTS_PROPERTIES = ModArmorItems::WATER_WALKING_BOOTS_PROPERTIES$lambda$2;
        OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES = ModArmorItems::OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES$lambda$3;
        LAVA_WADERS_PROPERTIES = ModArmorItems::LAVA_WADERS_PROPERTIES$lambda$4;
        Item.Properties properties2 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_HELMET.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"rarity(...)");
        SPECTRE_HELMET_PROPERTIES = properties2;
        Item.Properties properties3 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_CHESTPLATE.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties3, (String)"rarity(...)");
        SPECTRE_CHESTPLATE_PROPERTIES = properties3;
        Item.Properties properties4 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_LEGGINGS.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties4, (String)"rarity(...)");
        SPECTRE_LEGGINGS_PROPERTIES = properties4;
        Item.Properties properties5 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_BOOTS.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties5, (String)"rarity(...)");
        SPECTRE_BOOTS_PROPERTIES = properties5;
    }
}

