/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.language.ModTooltipLang;
import dev.aaronhowser.mods.irregular_implements.entity.SpectreIlluminatorEntity;
import dev.aaronhowser.mods.irregular_implements.handler.SpectreIlluminationHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SpectreIlluminatorItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "irregular-implements-1.21.1"})
public final class SpectreIlluminatorItem
extends Item {
    public SpectreIlluminatorItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        BlockPos clickedPos = context.getClickedPos();
        Player player = context.getPlayer();
        ServerLevel serverLevel = (ServerLevel)level;
        Intrinsics.checkNotNull((Object)clickedPos);
        if (SpectreIlluminationHandler.Companion.isChunkIlluminated(serverLevel, clickedPos)) {
            Player player2 = player;
            if (player2 != null) {
                player2.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.spectre_illuminator.already_present", new Object[0]).withStyle(ChatFormatting.RED));
            }
            return InteractionResult.FAIL;
        }
        Direction clickedFace = context.getClickedFace();
        Vec3 spawnPos = clickedPos.relative(clickedFace).getCenter();
        SpectreIlluminatorEntity entity = new SpectreIlluminatorEntity(level);
        entity.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        ((ServerLevel)level).addFreshEntity((Entity)entity);
        context.getItemInHand().consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        ModTooltipLang.INSTANCE.addSodiumTooltip(tooltipComponents);
    }
}

