/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.util;

import dev.aaronhowser.mods.irregular_implements.datagen.datapack.ModEnchantments;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="irregular_implements")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/util/ItemCatcher;", "", "<init>", "()V", "isCatchingDrops", "", "caughtItemEntities", "", "Lnet/minecraft/world/entity/item/ItemEntity;", "onEntityJoinLevel", "", "event", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "beforeDestroyBlock", "player", "Lnet/minecraft/server/level/ServerPlayer;", "afterDestroyBlock", "onLivingDropItems", "Lnet/neoforged/neoforge/event/entity/living/LivingDropsEvent;", "teleportTo", "itemEntity", "magneticEntity", "Lnet/minecraft/world/entity/LivingEntity;", "irregular-implements-1.21.1"})
public final class ItemCatcher {
    @NotNull
    public static final ItemCatcher INSTANCE = new ItemCatcher();
    private static boolean isCatchingDrops;
    @NotNull
    private static final List<ItemEntity> caughtItemEntities;

    private ItemCatcher() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onEntityJoinLevel(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!isCatchingDrops || event.isCanceled() || !(event.getEntity() instanceof ItemEntity)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.item.ItemEntity");
        caughtItemEntities.add((ItemEntity)entity);
    }

    @JvmStatic
    public static final void beforeDestroyBlock(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack usedItem = player.getMainHandItem();
        Holder.Reference magnetEnchant = player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ModEnchantments.INSTANCE.getMAGNETIC());
        boolean hasMagnetic = usedItem.getEnchantmentLevel((Holder)magnetEnchant) > 0;
        isCatchingDrops = hasMagnetic;
    }

    @JvmStatic
    public static final void afterDestroyBlock(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!isCatchingDrops) {
            return;
        }
        for (ItemEntity itemEntity : CollectionsKt.toList((Iterable)caughtItemEntities)) {
            INSTANCE.teleportTo(itemEntity, (LivingEntity)player);
        }
        caughtItemEntities.clear();
        isCatchingDrops = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onLivingDropItems(@NotNull LivingDropsEvent event) {
        Holder.Reference magnetEnchant;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled() || !event.getSource().isDirect()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity killer = livingEntity;
        ItemStack usedItem = killer.getMainHandItem();
        if (usedItem.getEnchantmentLevel((Holder)(magnetEnchant = killer.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(ModEnchantments.INSTANCE.getMAGNETIC()))) < 1) {
            return;
        }
        for (ItemEntity itemEntity : event.getDrops()) {
            this.teleportTo(itemEntity, killer);
        }
    }

    private final void teleportTo(ItemEntity itemEntity, LivingEntity magneticEntity) {
        if (itemEntity == null || magneticEntity == null) {
            return;
        }
        itemEntity.setNoPickUpDelay();
        if (magneticEntity instanceof Player) {
            itemEntity.playerTouch((Player)magneticEntity);
        }
        if (!itemEntity.getItem().isEmpty()) {
            itemEntity.setTarget(magneticEntity.getUUID());
            itemEntity.teleportTo(magneticEntity.getX(), magneticEntity.getY(), magneticEntity.getZ());
        }
    }

    static {
        caughtItemEntities = new ArrayList();
    }
}

