/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.world.village;

import com.mojang.datafixers.util.Pair;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/world/village/VillageAdditions;", "", "<init>", "()V", "EMPTY_PROCESSOR_LIST_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "addBuildingToPool", "", "templatePoolRegistry", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "processorListRegistry", "poolRl", "Lnet/minecraft/resources/ResourceLocation;", "nbtPiece", "", "weight", "", "addNewVillageBuildings", "event", "Lnet/neoforged/neoforge/event/server/ServerAboutToStartEvent;", "irregular-implements-1.21.1"})
public final class VillageAdditions {
    @NotNull
    public static final VillageAdditions INSTANCE = new VillageAdditions();
    @NotNull
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY;

    private VillageAdditions() {
    }

    private final void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRl, String nbtPiece, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)templatePoolRegistry.get(poolRl);
        if (structureTemplatePool == null) {
            return;
        }
        StructureTemplatePool pool = structureTemplatePool;
        LegacySinglePoolElement piece = (LegacySinglePoolElement)SinglePoolElement.legacy((String)nbtPiece, (Holder)((Holder)emptyProcessorList)).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        List list = pool.rawTemplates;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rawTemplates");
        List listOfPieceEntries = CollectionsKt.toMutableList((Collection)list);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    public final void addNewVillageBuildings(@NotNull ServerAboutToStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        Intrinsics.checkNotNull((Object)templatePoolRegistry);
        Intrinsics.checkNotNull((Object)processorListRegistry);
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"village/plains/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withDefaultNamespace(...)");
        String string = OtherUtil.modResource("candle_temple/plains_1").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation, string, 2);
        ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"village/plains/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"withDefaultNamespace(...)");
        String string2 = OtherUtil.modResource("candle_temple/plains_2").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation2, string2, 2);
        ResourceLocation resourceLocation3 = ResourceLocation.withDefaultNamespace((String)"village/desert/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"withDefaultNamespace(...)");
        String string3 = OtherUtil.modResource("candle_temple/desert_1").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation3, string3, 2);
        ResourceLocation resourceLocation4 = ResourceLocation.withDefaultNamespace((String)"village/desert/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"withDefaultNamespace(...)");
        String string4 = OtherUtil.modResource("candle_temple/desert_2").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation4, string4, 2);
        ResourceLocation resourceLocation5 = ResourceLocation.withDefaultNamespace((String)"village/savanna/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"withDefaultNamespace(...)");
        String string5 = OtherUtil.modResource("candle_temple/savanna_1").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation5, string5, 2);
        ResourceLocation resourceLocation6 = ResourceLocation.withDefaultNamespace((String)"village/savanna/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"withDefaultNamespace(...)");
        String string6 = OtherUtil.modResource("candle_temple/savanna_2").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation6, string6, 2);
        ResourceLocation resourceLocation7 = ResourceLocation.withDefaultNamespace((String)"village/snowy/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"withDefaultNamespace(...)");
        String string7 = OtherUtil.modResource("candle_temple/snowy_1").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation7, string7, 2);
        ResourceLocation resourceLocation8 = ResourceLocation.withDefaultNamespace((String)"village/taiga/houses");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"withDefaultNamespace(...)");
        String string8 = OtherUtil.modResource("candle_temple/taiga_2").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        this.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, resourceLocation8, string8, 2);
    }

    static {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        EMPTY_PROCESSOR_LIST_KEY = resourceKey;
    }
}

