/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class BasicRecipeTransferHandlerServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(Player player, List<TransferOperation> transferOperations, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        if (!RecipeTransferUtil.validateSlots(player, transferOperations, craftingSlots, inventorySlots)) {
            return;
        }
        Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack = BasicRecipeTransferHandlerServer.calculateRequiredStacks(transferOperations, player);
        if (recipeSlotToRequiredItemStack == null) {
            return;
        }
        boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
        Map<Slot, ItemStack> recipeSlotToTakenStacks = BasicRecipeTransferHandlerServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (recipeSlotToTakenStacks.isEmpty()) {
            LOGGER.error("Tried to transfer recipe but was unable to remove any items from the inventory.");
            return;
        }
        List<ItemStack> clearedCraftingItems = BasicRecipeTransferHandlerServer.clearCraftingGrid(craftingSlots, player);
        List<ItemStack> remainderItems = BasicRecipeTransferHandlerServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks, requireCompleteSets);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, clearedCraftingItems);
        BasicRecipeTransferHandlerServer.stowItems(player, inventorySlots, remainderItems);
        AbstractContainerMenu container = player.containerMenu;
        container.broadcastChanges();
    }

    private static int getSlotStackLimit(Map<Slot, ItemStack> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        if (!requireCompleteSets) {
            return Integer.MAX_VALUE;
        }
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            ItemStack transferItem;
            Slot craftingSlot = (Slot)e.getKey();
            if (craftingSlot.mayPlace(transferItem = (ItemStack)e.getValue())) {
                return craftingSlot.getMaxStackSize(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static List<ItemStack> clearCraftingGrid(List<Slot> craftingSlots, Player player) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Slot craftingSlot : craftingSlots) {
            ItemStack item;
            if (!craftingSlot.mayPickup(player) || (item = craftingSlot.getItem()).isEmpty() || !craftingSlot.mayPlace(item)) continue;
            ItemStack craftingItem = craftingSlot.safeTake(Integer.MAX_VALUE, Integer.MAX_VALUE, player);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<ItemStack> putItemsIntoCraftingGrid(Map<Slot, ItemStack> recipeSlotToTakenStacks, boolean requireCompleteSets) {
        int slotStackLimit = BasicRecipeTransferHandlerServer.getSlotStackLimit(recipeSlotToTakenStacks, requireCompleteSets);
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            ItemStack remainder = slot.safeInsert(stack, slotStackLimit);
            if (!remainder.isEmpty()) {
                remainderItems.add(remainder);
            }
        });
        return remainderItems;
    }

    @Nullable
    private static Map<Slot, ItemStackWithSlotHint> calculateRequiredStacks(List<TransferOperation> transferOperations, Player player) {
        HashMap<Slot, ItemStackWithSlotHint> recipeSlotToRequired = new HashMap<Slot, ItemStackWithSlotHint>(transferOperations.size());
        for (TransferOperation transferOperation : transferOperations) {
            Slot recipeSlot = transferOperation.craftingSlot(player.containerMenu);
            Slot inventorySlot = transferOperation.inventorySlot(player.containerMenu);
            if (!inventorySlot.allowModification(player)) {
                LOGGER.error("Tried to transfer recipe but was given an inventory slot that the player can't pickup from: {}", (Object)inventorySlot.index);
                return null;
            }
            ItemStack slotStack = inventorySlot.getItem();
            if (slotStack.isEmpty()) {
                LOGGER.error("Tried to transfer recipe but was given an empty inventory slot as an ingredient source: {}", (Object)inventorySlot.index);
                return null;
            }
            ItemStack stack = slotStack.copy();
            stack.setCount(1);
            recipeSlotToRequired.put(recipeSlot, new ItemStackWithSlotHint(inventorySlot, stack));
        }
        return recipeSlotToRequired;
    }

    private static Map<Slot, ItemStack> takeItemsFromInventory(Player player, Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<Slot, ItemStack> foundItemsInSet;
        if (!maxTransfer) {
            return BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<Slot, ItemStack> recipeSlotToResult = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = BasicRecipeTransferHandlerServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<Slot> fullSlots = BasicRecipeTransferHandlerServer.merge(recipeSlotToResult, foundItemsInSet);
            for (Slot fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<Slot, ItemStack> removeOneSetOfItemsFromInventory(Player player, Map<Slot, ItemStackWithSlotHint> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        HashMap<Slot, ItemStack> foundItemsInSet = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<Slot, ItemStackWithSlotHint> entry : recipeSlotToRequiredItemStack.entrySet()) {
            Slot recipeSlot = entry.getKey();
            ItemStack requiredStack = entry.getValue().stack;
            Slot hint = entry.getValue().hint;
            Slot sourceSlot = BasicRecipeTransferHandlerServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint).orElse(null);
            if (sourceSlot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(sourceSlot)) {
                    originalSlotContents.put(sourceSlot, sourceSlot.getItem().copy());
                }
                ItemStack removedItemStack = sourceSlot.safeTake(1, Integer.MAX_VALUE, player);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                Slot slot = (Slot)slotEntry.getKey();
                slot.set(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    private static Set<Slot> merge(Map<Slot, ItemStack> result, Map<Slot, ItemStack> addition) {
        HashSet<Slot> fullSlots = new HashSet<Slot>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.getCount() == 1);
            ItemStack resultItemStack = (ItemStack)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((Slot)slot, resultItemStack);
            } else {
                assert (ItemStack.isSameItemSameComponents((ItemStack)resultItemStack, (ItemStack)itemStack));
                resultItemStack.grow(itemStack.getCount());
            }
            if (resultItemStack.getCount() == slot.getMaxStackSize(resultItemStack)) {
                fullSlots.add((Slot)slot);
            }
        });
        return fullSlots;
    }

    private static Optional<Slot> getSlotWithStack(Player player, ItemStack stack, List<Slot> craftingSlots, List<Slot> inventorySlots, Slot hint) {
        return BasicRecipeTransferHandlerServer.getSlotWithStack(player, craftingSlots, stack).or(() -> BasicRecipeTransferHandlerServer.getValidatedHintSlot(player, stack, hint)).or(() -> BasicRecipeTransferHandlerServer.getSlotWithStack(player, inventorySlots, stack));
    }

    private static Optional<Slot> getValidatedHintSlot(Player player, ItemStack stack, Slot hint) {
        if (BasicRecipeTransferHandlerServer.isValidAndMatches(player, hint, stack)) {
            return Optional.of(hint);
        }
        return Optional.empty();
    }

    private static void stowItems(Player player, List<Slot> inventorySlots, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            ItemStack remainder = BasicRecipeTransferHandlerServer.stowItem(player, inventorySlots, itemStack);
            if (remainder.isEmpty() || player.getInventory().add(remainder)) continue;
            player.drop(remainder, false);
        }
    }

    private static ItemStack stowItem(Player player, Collection<Slot> slots, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = stack.copy();
        for (Slot slot : slots) {
            ItemStack inventoryStack;
            if (!slot.mayPickup(player) || (inventoryStack = slot.getItem()).isEmpty() || !inventoryStack.isStackable() || !(remainder = slot.safeInsert(remainder)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (Slot slot : slots) {
            if (!slot.getItem().isEmpty() || !(remainder = slot.safeInsert(remainder)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remainder;
    }

    private static Optional<Slot> getSlotWithStack(Player player, Collection<Slot> slots, ItemStack itemStack) {
        return slots.stream().filter(slot -> BasicRecipeTransferHandlerServer.isValidAndMatches(player, slot, itemStack)).findFirst();
    }

    private static boolean isValidAndMatches(Player player, Slot slot, ItemStack stack) {
        ItemStack containedStack = slot.getItem();
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)containedStack) && slot.allowModification(player);
    }

    private record ItemStackWithSlotHint(Slot hint, ItemStack stack) {
    }
}

