/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.utils.DeferredResource;

public interface HammerItems {
    public static final Item.Properties DEFAULT_PROPERTIES = new Item.Properties();
    public static final List<DeferredResource<Item, ? extends Item>> ITEMS = new ArrayList<DeferredResource<Item, ? extends Item>>();
    public static final List<DeferredResource<Item, HammerItem>> HAMMERS = new ArrayList<DeferredResource<Item, HammerItem>>();
    public static final DeferredResource<Item, HammerItem> STONE_HAMMER = HammerItems.registerHammer("stone", (Tier)Tiers.STONE, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> IRON_HAMMER = HammerItems.registerHammer("iron", (Tier)Tiers.IRON, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> GOLD_HAMMER = HammerItems.registerHammer("gold", (Tier)Tiers.GOLD, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> DIAMOND_HAMMER = HammerItems.registerHammer("diamond", (Tier)Tiers.DIAMOND, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> NETHERITE_HAMMER = HammerItems.registerHammer("netherite", (Tier)Tiers.NETHERITE, SizeOption.THREE_THREE, 1);
    public static final DeferredResource<Item, HammerItem> STONE_IMPACT_HAMMER = HammerItems.registerHammer("stone_impact", (Tier)Tiers.STONE, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> IRON_IMPACT_HAMMER = HammerItems.registerHammer("iron_impact", (Tier)Tiers.IRON, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> GOLD_IMPACT_HAMMER = HammerItems.registerHammer("gold_impact", (Tier)Tiers.GOLD, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> DIAMOND_IMPACT_HAMMER = HammerItems.registerHammer("diamond_impact", (Tier)Tiers.DIAMOND, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> NETHERITE_IMPACT_HAMMER = HammerItems.registerHammer("netherite_impact", (Tier)Tiers.NETHERITE, SizeOption.THREE_THREE_THREE, 2);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_HAMMER = HammerItems.registerHammer("stone_reinforced", (Tier)Tiers.STONE, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_HAMMER = HammerItems.registerHammer("iron_reinforced", (Tier)Tiers.IRON, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_HAMMER = HammerItems.registerHammer("gold_reinforced", (Tier)Tiers.GOLD, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_HAMMER = HammerItems.registerHammer("diamond_reinforced", (Tier)Tiers.DIAMOND, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_HAMMER = HammerItems.registerHammer("netherite_reinforced", (Tier)Tiers.NETHERITE, SizeOption.FIVE_FIVE, 3);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("stone_reinforced_impact", (Tier)Tiers.STONE, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("iron_reinforced_impact", (Tier)Tiers.IRON, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("gold_reinforced_impact", (Tier)Tiers.GOLD, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("diamond_reinforced_impact", (Tier)Tiers.DIAMOND, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_IMPACT_HAMMER = HammerItems.registerHammer("netherite_reinforced_impact", (Tier)Tiers.NETHERITE, SizeOption.FIVE_FIVE_THREE, 4);
    public static final DeferredResource<Item, HammerItem> STONE_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("stone_destructor", (Tier)Tiers.STONE, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> IRON_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("iron_destructor", (Tier)Tiers.IRON, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> GOLD_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("gold_destructor", (Tier)Tiers.GOLD, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> DIAMOND_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("diamond_destructor", (Tier)Tiers.DIAMOND, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, HammerItem> NETHERITE_FIVE_DESTROY_HAMMER = HammerItems.registerHammer("netherite_destructor", (Tier)Tiers.NETHERITE, SizeOption.FIVE_FIVE_FIVE, 5);
    public static final DeferredResource<Item, Item> IMPACT_CORE = HammerItems.register("impact_core", () -> new Item(DEFAULT_PROPERTIES));
    public static final DeferredResource<Item, Item> REINFORCED_CORE = HammerItems.register("reinforced_core", () -> new Item(DEFAULT_PROPERTIES));
    public static final DeferredResource<Item, Item> REINFORCED_IMPACT_CORE = HammerItems.register("reinforced_impact_core", () -> new Item(DEFAULT_PROPERTIES));
    public static final DeferredResource<Item, Item> DESTRUCTOR_CORE = HammerItems.register("destructor_core", () -> new Item(DEFAULT_PROPERTIES));

    private static DeferredResource<Item, HammerItem> registerHammer(String name, Tier tier, SizeOption size, int level) {
        DeferredResource<Item, HammerItem> register = HammerItems.register(name + "_hammer", () -> new HammerItem(tier, size.radius, size.depth, level));
        HAMMERS.add(register);
        return register;
    }

    private static <T extends Item> DeferredResource<Item, T> register(String name, Supplier<T> supplier) {
        DeferredResource entry = new DeferredResource(name, supplier);
        ITEMS.add(entry);
        return entry;
    }

    public static void init() {
    }

    public static enum SizeOption {
        THREE_THREE(3, 1),
        FIVE_FIVE(5, 1),
        THREE_THREE_THREE(3, 3),
        FIVE_FIVE_THREE(5, 3),
        FIVE_FIVE_FIVE(5, 5);

        final int radius;
        final int depth;

        private SizeOption(int radius, int depth) {
            this.radius = radius;
            this.depth = depth;
        }
    }
}

