/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.basescreens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ValueButtons;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ValueButtonsDouble;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.NumberButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.containers.basecontainers.BaseMachineContainer;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.containers.slots.FilterBasicSlot;
import com.direwolf20.justdirethings.common.network.data.AreaAffectingPayload;
import com.direwolf20.justdirethings.common.network.data.FilterSettingPayload;
import com.direwolf20.justdirethings.common.network.data.GhostSlotPayload;
import com.direwolf20.justdirethings.common.network.data.RedstoneSettingPayload;
import com.direwolf20.justdirethings.common.network.data.TickSpeedPayload;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class BaseMachineScreen<T extends BaseMachineContainer>
extends BaseScreen<T> {
    protected final ResourceLocation JUSTSLOT = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/justslot.png");
    protected final ResourceLocation POWERBAR = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/powerbar.png");
    protected final ResourceLocation FLUIDBAR = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/fluidbar.png");
    protected final ResourceLocation SOCIALBACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"background");
    protected BaseMachineContainer container;
    protected BaseMachineBE baseMachineBE;
    protected double xRadius = 3.0;
    protected double yRadius = 3.0;
    protected double zRadius = 3.0;
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected int zOffset = 0;
    protected boolean renderArea = false;
    protected FilterData filterData;
    protected MiscHelpers.RedstoneMode redstoneMode;
    protected List<ValueButtons> valueButtonsList = new ArrayList<ValueButtons>();
    protected List<ValueButtonsDouble> valueButtonsDoubleList = new ArrayList<ValueButtonsDouble>();
    protected int topSectionLeft;
    protected int topSectionTop;
    protected int topSectionWidth;
    protected int topSectionHeight;
    protected int extraWidth;
    protected int extraHeight;
    protected int direction;
    protected int tickSpeed;
    protected List<AbstractWidget> widgetsToRemove = new ArrayList<AbstractWidget>();
    protected List<AbstractWidget> widgetsToAdd = new ArrayList<AbstractWidget>();
    protected boolean renderablesChanged = false;

    public BaseMachineScreen(T container, Inventory pPlayerInventory, Component pTitle) {
        super(container, pPlayerInventory, pTitle);
        this.container = container;
        BaseMachineBE baseMachineBE = this.baseMachineBE = ((BaseMachineContainer)((Object)container)).baseMachineBE;
        if (baseMachineBE instanceof AreaAffectingBE) {
            AreaAffectingBE areaAffectingBE = (AreaAffectingBE)((Object)baseMachineBE);
            this.xRadius = areaAffectingBE.getAreaAffectingData().xRadius;
            this.yRadius = areaAffectingBE.getAreaAffectingData().yRadius;
            this.zRadius = areaAffectingBE.getAreaAffectingData().zRadius;
            this.xOffset = areaAffectingBE.getAreaAffectingData().xOffset;
            this.yOffset = areaAffectingBE.getAreaAffectingData().yOffset;
            this.zOffset = areaAffectingBE.getAreaAffectingData().zOffset;
            this.renderArea = areaAffectingBE.getAreaAffectingData().renderArea;
        }
        if ((baseMachineBE = this.baseMachineBE) instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            this.filterData = filterableBE.getFilterData();
        }
        if ((baseMachineBE = this.baseMachineBE) instanceof RedstoneControlledBE) {
            RedstoneControlledBE redstoneControlledBE = (RedstoneControlledBE)((Object)baseMachineBE);
            this.redstoneMode = redstoneControlledBE.getRedstoneControlData().redstoneMode;
        }
        if (this.baseMachineBE instanceof BaseMachineBE) {
            this.direction = this.baseMachineBE.getDirection();
            this.tickSpeed = this.baseMachineBE.getTickSpeed();
        }
    }

    public void calculateTopSection() {
        this.topSectionWidth = this.imageWidth + this.extraWidth;
        this.topSectionHeight = this.imageHeight + this.extraHeight - 64;
        this.topSectionLeft = this.getGuiLeft() - this.extraWidth / 2;
        this.topSectionTop = this.getGuiTop() - this.extraHeight - 26;
    }

    public void setTopSection() {
        this.extraWidth = 20;
        this.extraHeight = 0;
    }

    public void init() {
        super.init();
        this.setTopSection();
        this.calculateTopSection();
        this.valueButtonsList.clear();
        if (this.baseMachineBE instanceof AreaAffectingBE) {
            this.addAreaButtons();
        }
        if (this.baseMachineBE instanceof RedstoneControlledBE) {
            this.addRedstoneButtons();
        }
        if (this.baseMachineBE instanceof FilterableBE) {
            this.addFilterButtons();
        }
        this.addTickSpeedButton();
    }

    public void addTickSpeedButton() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.TICKSPEEDBUTTON(this.getGuiLeft() + 144, this.topSectionTop + 40, this.tickSpeed, b -> {
            this.tickSpeed = ((NumberButton)b).getValue();
            PacketDistributor.sendToServer((CustomPacketPayload)new TickSpeedPayload(this.tickSpeed), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
    }

    public void addRedstoneButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.REDSTONEBUTTON(this.getGuiLeft() + 134, this.topSectionTop + 62, this.redstoneMode.ordinal(), b -> {
            this.redstoneMode = MiscHelpers.RedstoneMode.values()[((ToggleButton)b).getTexturePosition()];
            this.saveSettings();
        }));
    }

    public void addFilterButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.ALLOWLISTBUTTON(this.getGuiLeft() + 8, this.topSectionTop + 62, this.filterData.allowlist, b -> {
            this.filterData.allowlist = !this.filterData.allowlist;
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COMPARENBTBUTTON(this.getGuiLeft() + 26, this.topSectionTop + 62, this.filterData.compareNBT, b -> {
            this.filterData.compareNBT = !this.filterData.compareNBT;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        if (this.filterData.blockItemFilter != -1) {
            this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.FILTERBLOCKITEMBUTTON(this.getGuiLeft() + 44, this.topSectionTop + 62, this.filterData.blockItemFilter, b -> {
                this.filterData.blockItemFilter = ((ToggleButton)b).getTexturePosition();
                this.saveSettings();
            }));
        }
    }

    public void addAreaButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.RENDERAREABUTTON(this.getGuiLeft() + 152, this.topSectionTop + 62, this.renderArea, b -> {
            this.renderArea = !this.renderArea;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.valueButtonsDoubleList.add(new ValueButtonsDouble(this.getGuiLeft() + 25, this.topSectionTop + 12, this.xRadius, 0.0, 5.0, this.font, (button, value) -> {
            this.xRadius = value;
            this.saveSettings();
        }));
        this.valueButtonsDoubleList.add(new ValueButtonsDouble(this.getGuiLeft() + 75, this.topSectionTop + 12, this.yRadius, 0.0, 5.0, this.font, (button, value) -> {
            this.yRadius = value;
            this.saveSettings();
        }));
        this.valueButtonsDoubleList.add(new ValueButtonsDouble(this.getGuiLeft() + 125, this.topSectionTop + 12, this.zRadius, 0.0, 5.0, this.font, (button, value) -> {
            this.zRadius = value;
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 25, this.topSectionTop + 27, this.xOffset, -9, 9, this.font, (button, value) -> {
            this.xOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 75, this.topSectionTop + 27, this.yOffset, -9, 9, this.font, (button, value) -> {
            this.yOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 125, this.topSectionTop + 27, this.zOffset, -9, 9, this.font, (button, value) -> {
            this.zOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.forEach(valueButtons -> valueButtons.widgetList.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }));
        this.valueButtonsDoubleList.forEach(valueButtons -> valueButtons.widgetList.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }));
    }

    public int adjustNumberButton(int value, int change, int min, int max) {
        if (Screen.hasShiftDown()) {
            change *= 10;
        }
        if (Screen.hasControlDown()) {
            change *= 64;
        }
        value = change < 0 ? Math.max(value + change, min) : Math.min(value + change, max);
        return value;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (MiscTools.inBounds(this.topSectionLeft, this.topSectionTop, this.topSectionWidth, this.topSectionHeight, mouseX, mouseY)) {
            return false;
        }
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.baseMachineBE != null) {
            MutableComponent title = this.baseMachineBE.getBlockState().getBlock().getName();
            int titleX = this.topSectionLeft - this.getGuiLeft() + 20 + (this.topSectionWidth - 40) / 2 - this.font.width((FormattedText)title) / 2;
            guiGraphics.drawString(this.font, (Component)title, titleX, this.topSectionTop - this.getGuiTop() - 14, 0x404040, false);
        }
        if (this.baseMachineBE instanceof AreaAffectingBE) {
            int areaWidth = 158;
            int xStart = this.topSectionLeft + this.topSectionWidth / 2 - areaWidth / 2 - this.getGuiLeft();
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Rad"), xStart - 4, this.topSectionTop - this.getGuiTop() + 14, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Off"), xStart - 4, this.topSectionTop - this.getGuiTop() + 29, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"X"), xStart + 35, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Y"), xStart + 85, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Z"), xStart + 135, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
        }
    }

    protected void drawSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof SlotItemHandler) {
            SlotItemHandler slotItemHandler = (SlotItemHandler)slot;
            if (slotItemHandler.getItemHandler() instanceof FilterBasicHandler) {
                this.drawFilterSlot(guiGraphics, slot);
            } else if (slotItemHandler.getItemHandler() instanceof InvWrapper) {
                this.drawInventorySlot(guiGraphics, slot);
            } else {
                this.drawMachineSlot(guiGraphics, slot);
            }
        } else {
            this.drawBasicSlot(guiGraphics, slot);
        }
    }

    protected void drawFilterSlot(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 0, 0, 18, 18);
    }

    protected void drawMachineSlot(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 0, 0, 18, 18);
    }

    protected void drawInventorySlot(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 0, 0, 18, 18);
    }

    protected void drawBasicSlot(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.blit(this.JUSTSLOT, this.getGuiLeft() + slot.x - 1, this.getGuiTop() + slot.y - 1, 0, 0, 18, 18);
    }

    public void renderInventorySection(GuiGraphics guiGraphics, int relX, int relY) {
        guiGraphics.blitSprite(this.SOCIALBACKGROUND, relX, relY + 83 - 8, this.imageWidth, this.imageHeight - 73);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        BaseMachineBE maxEnergy2;
        BaseMachineBE slot2;
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(this.SOCIALBACKGROUND, this.topSectionLeft + 20, this.topSectionTop - 20, this.topSectionWidth - 40, 20);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(this.SOCIALBACKGROUND, this.topSectionLeft, this.topSectionTop, this.topSectionWidth, this.topSectionHeight);
        this.renderInventorySection(guiGraphics, relX, relY);
        for (BaseMachineBE slot2 : this.container.slots) {
            this.drawSlot(guiGraphics, (Slot)slot2);
        }
        slot2 = this.baseMachineBE;
        if (slot2 instanceof PoweredMachineBE) {
            PoweredMachineBE poweredMachineBE = (PoweredMachineBE)((Object)slot2);
            guiGraphics.blit(this.POWERBAR, this.topSectionLeft + this.getEnergyBarOffset(), this.topSectionTop + 5, 0.0f, 0.0f, 18, 72, 36, 72);
            int maxEnergy2 = poweredMachineBE.getMaxEnergy();
            int height = 70;
            if (maxEnergy2 > 0) {
                int remaining = this.container.getEnergy() * height / maxEnergy2;
                guiGraphics.blit(this.POWERBAR, this.topSectionLeft + this.getEnergyBarOffset() + 1, this.topSectionTop + this.getEnergyBarOffset() + 72 - 2 - remaining, 19.0f, (float)(69 - remaining), 17, remaining + 1, 36, 72);
            }
        }
        if ((maxEnergy2 = this.baseMachineBE) instanceof FluidMachineBE) {
            FluidMachineBE fluidMachineBE = (FluidMachineBE)((Object)maxEnergy2);
            int offset = this.getFluidBarOffset();
            guiGraphics.blit(this.FLUIDBAR, this.topSectionLeft + offset, this.topSectionTop + 5, 0.0f, 0.0f, 18, 72, 36, 72);
            int maxMB = fluidMachineBE.getMaxMB();
            int height = 70;
            if (maxMB > 0) {
                int remaining = this.container.getFluidAmount() * height / maxMB;
                this.renderFluid(guiGraphics, this.topSectionLeft + offset + 1, this.topSectionTop + 5 + 72 - 1, 16, remaining);
            }
            guiGraphics.blit(this.FLUIDBAR, this.topSectionLeft + offset, this.topSectionTop + 5, 18.0f, 0.0f, 18, 72, 36, 72);
        }
        if (this.renderablesChanged) {
            this.updateRenderables();
        }
    }

    public int getEnergyBarOffset() {
        return 5;
    }

    public int getFluidBarOffset() {
        return this.baseMachineBE instanceof PoweredMachineBE ? 24 : this.getEnergyBarOffset();
    }

    public void renderFluid(GuiGraphics guiGraphics, int startX, int startY, int width, int height) {
        int drawHeight;
        FluidStack fluidStack = this.container.getFluidStack();
        if (fluidStack.isEmpty() || height <= 0) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        boolean zLevel = false;
        float uMin = fluidStillSprite.getU0();
        float uMax = fluidStillSprite.getU1();
        float vMin = fluidStillSprite.getV0();
        float vMax = fluidStillSprite.getV1();
        int textureWidth = fluidStillSprite.contents().width();
        int textureHeight = fluidStillSprite.contents().height();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int yOffset = 0; yOffset < height; yOffset += drawHeight) {
            int drawWidth;
            drawHeight = Math.min(textureHeight, height - yOffset);
            int drawY = startY - yOffset - drawHeight;
            float vMaxAdjusted = vMin + (vMax - vMin) * ((float)drawHeight / (float)textureHeight);
            for (int xOffset = 0; xOffset < width; xOffset += drawWidth) {
                drawWidth = Math.min(textureWidth, width - xOffset);
                float uMaxAdjusted = uMin + (uMax - uMin) * ((float)drawWidth / (float)textureWidth);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset), (float)(drawY + drawHeight), (float)zLevel).setUv(uMin, vMaxAdjusted);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset + drawWidth), (float)(drawY + drawHeight), (float)zLevel).setUv(uMaxAdjusted, vMaxAdjusted);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset + drawWidth), (float)drawY, (float)zLevel).setUv(uMaxAdjusted, vMin);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset), (float)drawY, (float)zLevel).setUv(uMin, vMin);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }

    public void powerBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof PoweredMachineBE) {
            PoweredMachineBE poweredMachineBE = (PoweredMachineBE)((Object)baseMachineBE);
            if (MiscTools.inBounds(this.topSectionLeft + this.getEnergyBarOffset(), this.topSectionTop + 5, 18, 72, pX, pY)) {
                if (BaseMachineScreen.hasShiftDown()) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.formatted(this.container.getEnergy()), MagicHelpers.formatted(poweredMachineBE.getMaxEnergy())}))), pX, pY);
                } else {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.container.getEnergy()), MagicHelpers.withSuffix(poweredMachineBE.getMaxEnergy())}))), pX, pY);
                }
            }
        }
    }

    public void fluidBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof FluidMachineBE) {
            FluidMachineBE fluidMachineBE = (FluidMachineBE)((Object)baseMachineBE);
            if (MiscTools.inBounds(this.topSectionLeft + this.getFluidBarOffset(), this.topSectionTop + 5, 18, 72, pX, pY)) {
                if (BaseMachineScreen.hasShiftDown()) {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.fluid", (Object[])new Object[]{this.container.getFluidStack().getHoverName(), MagicHelpers.formatted(this.container.getFluidAmount()), MagicHelpers.formatted(fluidMachineBE.getMaxMB())}))), pX, pY);
                } else {
                    pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.fluid", (Object[])new Object[]{this.container.getFluidStack().getHoverName(), MagicHelpers.withSuffix(this.container.getFluidAmount()), MagicHelpers.withSuffix(fluidMachineBE.getMaxMB())}))), pX, pY);
                }
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        this.powerBarTooltip(pGuiGraphics, pX, pY);
        this.fluidBarTooltip(pGuiGraphics, pX, pY);
    }

    public void onClose() {
        this.saveSettings();
        super.onClose();
    }

    public boolean mouseClicked(double x, double y, int btn) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof FilterableBE) {
            FilterableBE filterableBE = (FilterableBE)((Object)baseMachineBE);
            if (this.hoveredSlot != null && this.hoveredSlot instanceof FilterBasicSlot) {
                ItemStack stack = ((BaseMachineContainer)this.menu).getCarried();
                stack = stack.copy().split(this.hoveredSlot.getMaxStackSize());
                this.hoveredSlot.set(stack);
                PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        for (Renderable renderable : this.renderables) {
            ToggleButton toggleButton;
            NumberButton numberButton;
            if (renderable instanceof NumberButton && MiscTools.inBounds((numberButton = (NumberButton)renderable).getX(), numberButton.getY(), numberButton.getWidth(), numberButton.getHeight(), x, y)) {
                if (btn == 0) {
                    numberButton.setValue(this.adjustNumberButton(numberButton.getValue(), 1, numberButton.min, numberButton.max));
                } else if (btn == 1) {
                    numberButton.setValue(this.adjustNumberButton(numberButton.getValue(), -1, numberButton.min, numberButton.max));
                }
                numberButton.onPress();
                numberButton.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            if (!(renderable instanceof ToggleButton) || !MiscTools.inBounds((toggleButton = (ToggleButton)renderable).getX(), toggleButton.getY(), toggleButton.getWidth(), toggleButton.getHeight(), x, y) || btn != 1) continue;
            toggleButton.onClick(x, y, btn);
            toggleButton.playDownSound(Minecraft.getInstance().getSoundManager());
        }
        return super.mouseClicked(x, y, btn);
    }

    public void updateRenderables() {
        if (!this.widgetsToRemove.isEmpty()) {
            for (AbstractWidget abstractWidget : this.widgetsToRemove) {
                this.removeWidget((GuiEventListener)abstractWidget);
            }
            this.widgetsToRemove.clear();
        }
        if (!this.widgetsToAdd.isEmpty()) {
            for (AbstractWidget abstractWidget : this.widgetsToAdd) {
                this.addRenderableWidget((GuiEventListener)abstractWidget);
            }
            this.widgetsToAdd.clear();
        }
        this.renderablesChanged = false;
    }

    public void saveSettings() {
        if (this.baseMachineBE instanceof AreaAffectingBE) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AreaAffectingPayload(this.xRadius, this.yRadius, this.zRadius, this.xOffset, this.yOffset, this.zOffset, this.renderArea), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.baseMachineBE instanceof FilterableBE) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FilterSettingPayload(this.filterData.allowlist, this.filterData.compareNBT, this.filterData.blockItemFilter), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.baseMachineBE instanceof RedstoneControlledBE) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RedstoneSettingPayload(this.redstoneMode.ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

