/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.entities.PortalProjectile;
import com.direwolf20.justdirethings.common.fluids.portalfluid.PortalFluidBlock;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.BasePoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.FluidContainingItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class PortalGunV2
extends BasePoweredItem
implements PoweredItem,
FluidContainingItem {
    public static final int MAX_FAVORITES = 12;
    public static final int maxMB = 8000;

    public PortalGunV2() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.PORTAL_GUN_V2_RF_CAPACITY.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = PortalGunV2.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() == HitResult.Type.BLOCK && PortalGunV2.pickupFluid(level, player, itemStack, blockhitresult)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (!level.isClientSide) {
            PortalGunV2.spawnProjectile(level, player, itemStack, true);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"justdirethings.portalfluidamt", (Object[])new Object[]{MagicHelpers.formatted(fluidHandler.getFluidInTank(0).getAmount()), MagicHelpers.formatted(8000)}).withStyle(ChatFormatting.GREEN));
    }

    public static boolean pickupFluid(Level level, Player player, ItemStack itemStack, BlockHitResult blockhitresult) {
        BlockPos blockpos = blockhitresult.getBlockPos();
        BlockState blockstate1 = level.getBlockState(blockpos);
        Block block = blockstate1.getBlock();
        if (block instanceof PortalFluidBlock) {
            PortalFluidBlock portalFluidBlock = (PortalFluidBlock)block;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler == null) {
                return true;
            }
            int filledAmt = fluidHandler.fill(new FluidStack((Fluid)Registration.PORTAL_FLUID_SOURCE.get(), 1000), IFluidHandler.FluidAction.SIMULATE);
            if (filledAmt == 1000) {
                ItemStack itemstack2 = portalFluidBlock.pickupBlock(player, (LevelAccessor)level, blockpos, blockstate1);
                fluidHandler.fill(new FluidStack((Fluid)Registration.PORTAL_FLUID_SOURCE.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                portalFluidBlock.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.playSound(p_150709_, 1.0f, 1.0f));
                if (!level.isClientSide) {
                    CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack2);
                }
            }
            return true;
        }
        return false;
    }

    public static void spawnProjectile(Level level, Player player, ItemStack itemStack, boolean isPrimaryType) {
        NBTHelpers.PortalDestination portalDestination;
        NBTHelpers.PortalDestination portalDestination2 = portalDestination = player.isShiftKeyDown() ? PortalGunV2.getPrevious(itemStack) : PortalGunV2.getSelectedFavorite(itemStack);
        if (portalDestination == null || portalDestination.equals(NBTHelpers.PortalDestination.EMPTY)) {
            return;
        }
        int cost = PortalGunV2.calculateFluidCost((ServerLevel)level, player, portalDestination);
        if (!PortalGunV2.hasEnoughFluid(itemStack, cost)) {
            player.displayClientMessage((Component)Component.translatable((String)"justdirethings.lowportalfluid"), true);
            player.playNotifySound(SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (!PoweredItem.consumeEnergy(itemStack, (Integer)Config.PORTAL_GUN_V2_RF_COST.get())) {
            player.displayClientMessage((Component)Component.translatable((String)"justdirethings.lowenergy"), true);
            player.playNotifySound(SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        PortalProjectile projectile = new PortalProjectile(level, player, PortalGunV2.getUUID(itemStack), isPrimaryType, true, portalDestination);
        projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
        level.addFreshEntity((Entity)projectile);
        PortalGunV2.consumeFluid(itemStack, cost);
        PortalGunV2.setPrevious(player, itemStack);
    }

    public static int calculateFluidCost(ServerLevel sourceLevel, Player player, NBTHelpers.PortalDestination portalDestination) {
        if (player.isCreative()) {
            return 0;
        }
        ServerLevel targetLevel = sourceLevel.getServer().getLevel(portalDestination.globalVec3().dimension());
        if (!targetLevel.equals(sourceLevel)) {
            return 100;
        }
        HitResult result = player.pick(5.0, 0.0f, false);
        Vec3 targetPosition = portalDestination.globalVec3().position();
        double distance = targetPosition.distanceTo(result.getLocation());
        return Math.min((int)Math.ceil(distance * 0.25), 100);
    }

    public static boolean hasEnoughFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.getFluidInTank(0).getAmount() >= amt;
    }

    public static void consumeFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        fluidHandler.drain(amt, IFluidHandler.FluidAction.EXECUTE);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static UUID setUUID(ItemStack itemStack) {
        UUID uuid = UUID.randomUUID();
        itemStack.set(JustDireDataComponents.PORTALGUN_UUID, (Object)uuid);
        return uuid;
    }

    public static UUID getUUID(ItemStack itemStack) {
        if (!itemStack.has(JustDireDataComponents.PORTALGUN_UUID)) {
            return PortalGunV2.setUUID(itemStack);
        }
        return (UUID)itemStack.get(JustDireDataComponents.PORTALGUN_UUID);
    }

    public static NBTHelpers.PortalDestination getSelectedFavorite(ItemStack itemStack) {
        ArrayList<NBTHelpers.PortalDestination> favoritesList = new ArrayList<NBTHelpers.PortalDestination>(PortalGunV2.getFavorites(itemStack));
        if (favoritesList.isEmpty()) {
            return null;
        }
        return (NBTHelpers.PortalDestination)favoritesList.get(PortalGunV2.getFavoritePosition(itemStack));
    }

    public static NBTHelpers.PortalDestination getFavorite(ItemStack itemStack, int slot) {
        ArrayList<NBTHelpers.PortalDestination> favoritesList = new ArrayList<NBTHelpers.PortalDestination>(PortalGunV2.getFavorites(itemStack));
        if (favoritesList.isEmpty()) {
            return null;
        }
        return (NBTHelpers.PortalDestination)favoritesList.get(slot);
    }

    public static int getFavoritePosition(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(JustDireDataComponents.PORTALGUN_FAVORITE, (Object)0);
    }

    public static void setFavoritePosition(ItemStack itemStack, int favorite) {
        itemStack.set(JustDireDataComponents.PORTALGUN_FAVORITE, (Object)favorite);
    }

    public static List<NBTHelpers.PortalDestination> getFavorites(ItemStack itemStack) {
        return (List)itemStack.getOrDefault(JustDireDataComponents.PORTAL_GUN_FAVORITES, new ArrayList());
    }

    public static void setFavorites(ItemStack itemStack, List<NBTHelpers.PortalDestination> favorites) {
        itemStack.set(JustDireDataComponents.PORTAL_GUN_FAVORITES, favorites);
    }

    public static void setPrevious(Player player, ItemStack itemStack) {
        Vec3 position = player.position();
        Direction facing = MiscHelpers.getFacingDirection(player);
        if (facing == Direction.DOWN) {
            facing = Direction.NORTH;
        }
        ResourceKey dimension = player.level().dimension();
        NBTHelpers.PortalDestination newDestination = new NBTHelpers.PortalDestination(new NBTHelpers.GlobalVec3((ResourceKey<Level>)dimension, position), facing, "previous");
        itemStack.set(JustDireDataComponents.PORTAL_GUN_PREVIOUS, (Object)newDestination);
    }

    public static NBTHelpers.PortalDestination getPrevious(ItemStack itemStack) {
        return (NBTHelpers.PortalDestination)itemStack.getOrDefault(JustDireDataComponents.PORTAL_GUN_PREVIOUS, (Object)NBTHelpers.PortalDestination.EMPTY);
    }

    public static void addFavorite(ItemStack itemStack, int position, NBTHelpers.PortalDestination portalDestination) {
        if (!itemStack.has(JustDireDataComponents.PORTAL_GUN_FAVORITES)) {
            ArrayList<NBTHelpers.PortalDestination> list = new ArrayList<NBTHelpers.PortalDestination>(12);
            for (int i = 0; i < 12; ++i) {
                list.add(NBTHelpers.PortalDestination.EMPTY);
            }
            PortalGunV2.setFavorites(itemStack, list);
        }
        ArrayList<NBTHelpers.PortalDestination> favoritesList = new ArrayList<NBTHelpers.PortalDestination>(PortalGunV2.getFavorites(itemStack));
        favoritesList.set(position, portalDestination);
        PortalGunV2.setFavorites(itemStack, favoritesList);
    }

    public static void removeFavorite(ItemStack itemStack, int position) {
        ArrayList<NBTHelpers.PortalDestination> favoritesList = new ArrayList<NBTHelpers.PortalDestination>(PortalGunV2.getFavorites(itemStack));
        if (favoritesList.isEmpty()) {
            return;
        }
        favoritesList.set(position, NBTHelpers.PortalDestination.EMPTY);
        PortalGunV2.setFavorites(itemStack, favoritesList);
    }

    public static boolean getStayOpen(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(JustDireDataComponents.PORTAL_GUN_STAY_OPEN, (Object)false);
    }

    public static void setStayOpen(ItemStack itemStack, boolean stayOpen) {
        itemStack.set(JustDireDataComponents.PORTAL_GUN_STAY_OPEN, (Object)stayOpen);
    }

    public static ItemStack getPortalGunv2(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof PortalGunV2) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof PortalGunV2) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }

    public static int getFullness(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && !fluidHandler.getFluidInTank(0).isEmpty()) {
            float percentFull = (float)fluidHandler.getFluidInTank(0).getAmount() / 8000.0f * 100.0f;
            if (percentFull > 0.0f && percentFull <= 33.0f) {
                return 1;
            }
            if (percentFull > 33.0f && percentFull <= 66.0f) {
                return 2;
            }
            if (percentFull > 66.0f) {
                return 3;
            }
        }
        return 0;
    }
}

