/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.armors;

import com.direwolf20.justdirethings.common.items.armors.basearmors.BaseChestplate;
import com.direwolf20.justdirethings.common.items.armors.utils.ArmorTiers;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;

public class EclipseAlloyChestplate
extends BaseChestplate
implements PoweredTool {
    public EclipseAlloyChestplate() {
        super(ArmorTiers.ECLIPSEALLOY, new Item.Properties().fireResistant().durability(ArmorItem.Type.CHESTPLATE.getDurability(25)));
        this.registerAbility(Ability.INVULNERABILITY, new AbilityParams(1, 1, 1, 1, 200, 400));
        this.registerAbility(Ability.EXTINGUISH, new AbilityParams(1, 1, 1, 1, 0, 40));
        this.registerAbility(Ability.ELYTRA);
        this.registerAbility(Ability.FLIGHT);
        this.registerAbility(Ability.LAVAIMMUNITY);
        this.registerAbility(Ability.DEATHPROTECTION, new AbilityParams(1, 1, 1, 1, 0, 6000));
        this.registerAbility(Ability.TIMEPROTECTION);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isPowerBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getPowerBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        int color = this.getPowerBarColor(stack);
        if (color == -1) {
            return super.getBarColor(stack);
        }
        return color;
    }

    public static boolean isFlyEnabled(ItemStack elytraStack) {
        ToggleableTool toggleableTool;
        Item item = elytraStack.getItem();
        return item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(elytraStack, Ability.ELYTRA);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return EclipseAlloyChestplate.isFlyEnabled(stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                Helpers.damageTool(stack, entity, Ability.ELYTRA);
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    @Override
    public int getMaxEnergy() {
        return 500000;
    }
}

