/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.reforger;

import com.devdyna.justdynathings.recipetypes.input.BlockStateItemInput;
import com.devdyna.justdynathings.recipetypes.input.BlockTagItemInput;
import com.devdyna.justdynathings.recipetypes.type.ReforgerMTORecipe;
import com.devdyna.justdynathings.recipetypes.type.ReforgerOTMRecipe;
import com.devdyna.justdynathings.recipetypes.type.ReforgerOTORecipe;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.registry.types.zRecipeTypes;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.client.particles.gooexplodeparticle.GooExplodeParticleData;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.crafting.BlockTagIngredient;

public class ReforgerBE
extends BaseMachineBE
implements RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();

    public ReforgerBE(BlockEntityType<?> p, BlockPos b, BlockState s) {
        super(p, b, s);
        this.MACHINE_SLOTS = 1;
    }

    public ReforgerBE(BlockPos p, BlockState s) {
        this((BlockEntityType)zBlockEntities.REFORGER.get(), p, s);
    }

    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public void tickServer() {
        super.tickServer();
        ItemStack item = this.getMachineHandler().getStackInSlot(0);
        BlockPos posRel = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        BlockState stateRelated = this.level.getBlockState(posRel);
        if (item != null) {
            this.updateBlock(item);
        }
        if (this.level.getGameTime() % (long)this.tickSpeed == 0L && this.isActiveRedstone() && ((Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE)).booleanValue()) {
            Optional oto = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.REFORGER_OTO.getType(), (RecipeInput)new BlockStateItemInput(stateRelated, item), this.level);
            if (!oto.isEmpty()) {
                ReforgerOTORecipe recipe = (ReforgerOTORecipe)((RecipeHolder)oto.get()).value();
                this.success(recipe.getOutputState(), posRel, item, this.level, recipe.getChanceToUse());
                return;
            }
            Optional otm = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.REFORGER_OTM.getType(), (RecipeInput)new BlockStateItemInput(stateRelated, item), this.level);
            if (!otm.isEmpty()) {
                ReforgerOTMRecipe recipe = (ReforgerOTMRecipe)((RecipeHolder)otm.get()).value();
                TagKey tag = recipe.getOutputState().getTag();
                this.success(LevelUtil.ResourceByTag((TagKey<Block>)tag, LevelUtil.getRandomValue(LevelUtil.getSizeTag((TagKey<Block>)tag), this.level)).defaultBlockState(), posRel, item, this.level, recipe.getChanceToUse());
                return;
            }
            for (TagKey tag : stateRelated.getTags().toList()) {
                Optional mto = this.level.getRecipeManager().getRecipeFor(zRecipeTypes.REFORGER_MTO.getType(), (RecipeInput)new BlockTagItemInput(new BlockTagIngredient(tag), item), this.level);
                if (mto.isEmpty()) continue;
                ReforgerMTORecipe recipe = (ReforgerMTORecipe)((RecipeHolder)mto.get()).value();
                this.success(recipe.getOutputState(), posRel, item, this.level, recipe.getChanceToUse());
                return;
            }
        }
    }

    public void updateBlock(ItemStack item) {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(!item.isEmpty())));
    }

    public void success(BlockState b, BlockPos pos, ItemStack item, Level level, int cosChance) {
        this.spawnParticles((ServerLevel)level, pos);
        this.applySound();
        if (b.getOptionalValue((Property)BlockStateProperties.FACING).isPresent()) {
            b = (BlockState)b.trySetValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)));
        }
        level.setBlockAndUpdate(pos, b);
        if (LevelUtil.chance(cosChance, level)) {
            item.shrink(1);
        }
    }

    public void applySound() {
        if (LevelUtil.chance(50, this.level)) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.STRIDER_EAT, SoundSource.BLOCKS, 1.0f, 0.1f);
        }
    }

    public void spawnParticles(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            level.sendParticles((ParticleOptions)new GooExplodeParticleData(new ItemStack((ItemLike)level.getBlockState(pos).getBlock())), (double)pos.getX() + new Random().nextDouble(), (double)pos.getY() + new Random().nextDouble(), (double)pos.getZ() + new Random().nextDouble(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

