/*
 * Decompiled with CFR 0.152.
 */
package net.zhaiji.kubejscurios.event;

import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.bus.api.IEventBus;
import net.zhaiji.kubejscurios.kubejs.KubeJSCuriosEventJS;
import net.zhaiji.kubejscurios.kubejs.KubeJSCuriosEvents;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioCanEquipEvent;
import top.theillusivec4.curios.api.event.CurioCanUnequipEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;

public class EventHandler {
    public static void addGameBusListener(IEventBus gameEventBus) {
        gameEventBus.addListener(EventHandler::CurioAttributeModifierEvent);
        gameEventBus.addListener(EventHandler::CurioCanEquipEvent);
        gameEventBus.addListener(EventHandler::CurioCanUnequipEvent);
        gameEventBus.addListener(EventHandler::CurioChangeEvent);
        gameEventBus.addListener(EventHandler::CurioDropsEvent);
        gameEventBus.addListener(EventHandler::DropRulesEvent);
        gameEventBus.addListener(EventHandler::SlotModifiersUpdatedEvent);
    }

    public static void CurioAttributeModifierEvent(CurioAttributeModifierEvent event) {
        LivingEntity entity = event.getSlotContext().entity();
        ScriptType scriptType = entity != null && !entity.level().isClientSide() ? ScriptType.SERVER : ScriptType.CLIENT;
        KubeJSCuriosEvents.ATTRIBUTE_MODIFIER.post((ScriptTypeHolder)scriptType, (KubeEvent)new KubeJSCuriosEventJS.CurioAttributeModifier(event.getItemStack(), event.getSlotContext(), event.getId(), (Multimap<Holder<Attribute>, AttributeModifier>)event.getModifiers()));
    }

    public static void CurioCanEquipEvent(CurioCanEquipEvent event) {
        ScriptType scriptType = event.getEntity().level().isClientSide() ? ScriptType.CLIENT : ScriptType.SERVER;
        KubeJSCuriosEventJS.CurioCanEquip evt = new KubeJSCuriosEventJS.CurioCanEquip(event.getEntity(), event.getSlotContext(), event.getStack(), event.getEquipResult());
        KubeJSCuriosEvents.CAN_EQUIP.post((ScriptTypeHolder)scriptType, (KubeEvent)evt);
        event.setEquipResult(evt.result);
    }

    public static void CurioCanUnequipEvent(CurioCanUnequipEvent event) {
        ScriptType scriptType = event.getEntity().level().isClientSide() ? ScriptType.CLIENT : ScriptType.SERVER;
        KubeJSCuriosEventJS.CurioCanUnequip evt = new KubeJSCuriosEventJS.CurioCanUnequip(event.getEntity(), event.getSlotContext(), event.getStack(), event.getUnequipResult());
        KubeJSCuriosEvents.CAN_UNEQUIP.post((ScriptTypeHolder)scriptType, (KubeEvent)evt);
        event.setUnequipResult(evt.result);
    }

    public static void CurioChangeEvent(CurioChangeEvent event) {
        KubeJSCuriosEvents.CHANGE.post((KubeEvent)new KubeJSCuriosEventJS.CurioChange(event.getEntity(), event.getIdentifier(), event.getSlotIndex(), event.getFrom(), event.getTo()));
    }

    public static void CurioDropsEvent(CurioDropsEvent event) {
        EventResult eventResult = KubeJSCuriosEvents.DROPS.post((KubeEvent)new KubeJSCuriosEventJS.CurioDrops(event.getEntity(), event.getSource(), event.getDrops(), event.getLootingLevel(), event.isRecentlyHit(), event.getCurioHandler()));
        if (eventResult.interruptFalse()) {
            event.setCanceled(true);
        }
    }

    public static void DropRulesEvent(DropRulesEvent event) {
        KubeJSCuriosEvents.DROP_RULES.post((KubeEvent)new KubeJSCuriosEventJS.DropRules(event.getEntity(), event.getSource(), event.getLootingLevel(), event.isRecentlyHit(), event.getCurioHandler()));
    }

    public static void SlotModifiersUpdatedEvent(SlotModifiersUpdatedEvent event) {
        ScriptType scriptType = event.getEntity().level().isClientSide() ? ScriptType.CLIENT : ScriptType.SERVER;
        KubeJSCuriosEvents.SLOT_MODIFIER_UPDATED.post((ScriptTypeHolder)scriptType, (KubeEvent)new KubeJSCuriosEventJS.SlotModifiersUpdated(event.getEntity(), event.getTypes()));
    }
}

